// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tpu/v1/cloud_tpu.proto

#include "google/cloud/tpu/v1/tpu_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace tpu_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TpuClient::TpuClient(std::shared_ptr<TpuConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
TpuClient::~TpuClient() = default;

StreamRange<google::cloud::tpu::v1::Node> TpuClient::ListNodes(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tpu::v1::ListNodesRequest request;
  request.set_parent(parent);
  return connection_->ListNodes(request);
}

StreamRange<google::cloud::tpu::v1::Node> TpuClient::ListNodes(
    google::cloud::tpu::v1::ListNodesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNodes(std::move(request));
}

StatusOr<google::cloud::tpu::v1::Node> TpuClient::GetNode(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tpu::v1::GetNodeRequest request;
  request.set_name(name);
  return connection_->GetNode(request);
}

StatusOr<google::cloud::tpu::v1::Node> TpuClient::GetNode(
    google::cloud::tpu::v1::GetNodeRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNode(request);
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuClient::CreateNode(
    std::string const& parent, google::cloud::tpu::v1::Node const& node,
    std::string const& node_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tpu::v1::CreateNodeRequest request;
  request.set_parent(parent);
  *request.mutable_node() = node;
  request.set_node_id(node_id);
  return connection_->CreateNode(request);
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuClient::CreateNode(
    google::cloud::tpu::v1::CreateNodeRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNode(request);
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuClient::DeleteNode(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tpu::v1::DeleteNodeRequest request;
  request.set_name(name);
  return connection_->DeleteNode(request);
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuClient::DeleteNode(
    google::cloud::tpu::v1::DeleteNodeRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNode(request);
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuClient::ReimageNode(
    google::cloud::tpu::v1::ReimageNodeRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReimageNode(request);
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuClient::StopNode(
    google::cloud::tpu::v1::StopNodeRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopNode(request);
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuClient::StartNode(
    google::cloud::tpu::v1::StartNodeRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartNode(request);
}

StreamRange<google::cloud::tpu::v1::TensorFlowVersion>
TpuClient::ListTensorFlowVersions(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tpu::v1::ListTensorFlowVersionsRequest request;
  request.set_parent(parent);
  return connection_->ListTensorFlowVersions(request);
}

StreamRange<google::cloud::tpu::v1::TensorFlowVersion>
TpuClient::ListTensorFlowVersions(
    google::cloud::tpu::v1::ListTensorFlowVersionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTensorFlowVersions(std::move(request));
}

StatusOr<google::cloud::tpu::v1::TensorFlowVersion>
TpuClient::GetTensorFlowVersion(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tpu::v1::GetTensorFlowVersionRequest request;
  request.set_name(name);
  return connection_->GetTensorFlowVersion(request);
}

StatusOr<google::cloud::tpu::v1::TensorFlowVersion>
TpuClient::GetTensorFlowVersion(
    google::cloud::tpu::v1::GetTensorFlowVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTensorFlowVersion(request);
}

StreamRange<google::cloud::tpu::v1::AcceleratorType>
TpuClient::ListAcceleratorTypes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tpu::v1::ListAcceleratorTypesRequest request;
  request.set_parent(parent);
  return connection_->ListAcceleratorTypes(request);
}

StreamRange<google::cloud::tpu::v1::AcceleratorType>
TpuClient::ListAcceleratorTypes(
    google::cloud::tpu::v1::ListAcceleratorTypesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAcceleratorTypes(std::move(request));
}

StatusOr<google::cloud::tpu::v1::AcceleratorType> TpuClient::GetAcceleratorType(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tpu::v1::GetAcceleratorTypeRequest request;
  request.set_name(name);
  return connection_->GetAcceleratorType(request);
}

StatusOr<google::cloud::tpu::v1::AcceleratorType> TpuClient::GetAcceleratorType(
    google::cloud::tpu::v1::GetAcceleratorTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAcceleratorType(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tpu_v1
}  // namespace cloud
}  // namespace google
