// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/metric_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_METRIC_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_METRIC_CLIENT_H

#include "google/cloud/monitoring/v3/metric_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Manages metric descriptors, monitored resource descriptors, and
/// time series data.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class MetricServiceClient {
 public:
  explicit MetricServiceClient(
      std::shared_ptr<MetricServiceConnection> connection, Options opts = {});
  ~MetricServiceClient();

  ///@{
  /// @name Copy and move support
  MetricServiceClient(MetricServiceClient const&) = default;
  MetricServiceClient& operator=(MetricServiceClient const&) = default;
  MetricServiceClient(MetricServiceClient&&) = default;
  MetricServiceClient& operator=(MetricServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(MetricServiceClient const& a,
                         MetricServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(MetricServiceClient const& a,
                         MetricServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists monitored resource descriptors that match a filter. This method does not require a Workspace.
  ///
  /// @param name  Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name) on
  ///  which to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.api.MonitoredResourceDescriptor], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.MonitoredResourceDescriptor]: @googleapis_reference_link{google/api/monitored_resource.proto#L41}
  /// [google.monitoring.v3.ListMonitoredResourceDescriptorsRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L175}
  ///
  // clang-format on
  StreamRange<google::api::MonitoredResourceDescriptor>
  ListMonitoredResourceDescriptors(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Lists monitored resource descriptors that match a filter. This method does not require a Workspace.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.ListMonitoredResourceDescriptorsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.api.MonitoredResourceDescriptor], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.MonitoredResourceDescriptor]: @googleapis_reference_link{google/api/monitored_resource.proto#L41}
  /// [google.monitoring.v3.ListMonitoredResourceDescriptorsRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L175}
  ///
  // clang-format on
  StreamRange<google::api::MonitoredResourceDescriptor>
  ListMonitoredResourceDescriptors(
      google::monitoring::v3::ListMonitoredResourceDescriptorsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a single monitored resource descriptor. This method does not require a Workspace.
  ///
  /// @param name  Required. The monitored resource descriptor to get.  The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]/monitoredResourceDescriptors/[RESOURCE_TYPE]
  ///  @n
  ///  The `[RESOURCE_TYPE]` is a predefined type, such as
  ///  `cloudsql_database`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.MonitoredResourceDescriptor])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.MonitoredResourceDescriptor]: @googleapis_reference_link{google/api/monitored_resource.proto#L41}
  /// [google.monitoring.v3.GetMonitoredResourceDescriptorRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L217}
  ///
  // clang-format on
  StatusOr<google::api::MonitoredResourceDescriptor>
  GetMonitoredResourceDescriptor(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a single monitored resource descriptor. This method does not require a Workspace.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.GetMonitoredResourceDescriptorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.MonitoredResourceDescriptor])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.MonitoredResourceDescriptor]: @googleapis_reference_link{google/api/monitored_resource.proto#L41}
  /// [google.monitoring.v3.GetMonitoredResourceDescriptorRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L217}
  ///
  // clang-format on
  StatusOr<google::api::MonitoredResourceDescriptor>
  GetMonitoredResourceDescriptor(
      google::monitoring::v3::GetMonitoredResourceDescriptorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists metric descriptors that match a filter. This method does not require a Workspace.
  ///
  /// @param name  Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name) on
  ///  which to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.api.MetricDescriptor], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.MetricDescriptor]: @googleapis_reference_link{google/api/metric.proto#L33}
  /// [google.monitoring.v3.ListMetricDescriptorsRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L233}
  ///
  // clang-format on
  StreamRange<google::api::MetricDescriptor> ListMetricDescriptors(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Lists metric descriptors that match a filter. This method does not require a Workspace.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.ListMetricDescriptorsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.api.MetricDescriptor], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.MetricDescriptor]: @googleapis_reference_link{google/api/metric.proto#L33}
  /// [google.monitoring.v3.ListMetricDescriptorsRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L233}
  ///
  // clang-format on
  StreamRange<google::api::MetricDescriptor> ListMetricDescriptors(
      google::monitoring::v3::ListMetricDescriptorsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a single metric descriptor. This method does not require a Workspace.
  ///
  /// @param name  Required. The metric descriptor on which to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]/metricDescriptors/[METRIC_ID]
  ///  @n
  ///  An example value of `[METRIC_ID]` is
  ///  `"compute.googleapis.com/instance/disk/read_bytes_count"`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.MetricDescriptor])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.MetricDescriptor]: @googleapis_reference_link{google/api/metric.proto#L33}
  /// [google.monitoring.v3.GetMetricDescriptorRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L277}
  ///
  // clang-format on
  StatusOr<google::api::MetricDescriptor> GetMetricDescriptor(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a single metric descriptor. This method does not require a Workspace.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.GetMetricDescriptorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.MetricDescriptor])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.MetricDescriptor]: @googleapis_reference_link{google/api/metric.proto#L33}
  /// [google.monitoring.v3.GetMetricDescriptorRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L277}
  ///
  // clang-format on
  StatusOr<google::api::MetricDescriptor> GetMetricDescriptor(
      google::monitoring::v3::GetMetricDescriptorRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new metric descriptor.
  /// The creation is executed asynchronously and callers may check the returned
  /// operation to track its progress.
  /// User-created metric descriptors define
  /// [custom metrics](https://cloud.google.com/monitoring/custom-metrics).
  ///
  /// @param name  Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name) on
  ///  which to execute the request. The format is:
  ///  4
  ///      projects/[PROJECT_ID_OR_NUMBER]
  /// @param metric_descriptor  Required. The new [custom metric](https://cloud.google.com/monitoring/custom-metrics)
  ///  descriptor.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.MetricDescriptor])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.MetricDescriptor]: @googleapis_reference_link{google/api/metric.proto#L33}
  /// [google.monitoring.v3.CreateMetricDescriptorRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L293}
  ///
  // clang-format on
  StatusOr<google::api::MetricDescriptor> CreateMetricDescriptor(
      std::string const& name,
      google::api::MetricDescriptor const& metric_descriptor,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new metric descriptor.
  /// The creation is executed asynchronously and callers may check the returned
  /// operation to track its progress.
  /// User-created metric descriptors define
  /// [custom metrics](https://cloud.google.com/monitoring/custom-metrics).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.CreateMetricDescriptorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.MetricDescriptor])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.MetricDescriptor]: @googleapis_reference_link{google/api/metric.proto#L33}
  /// [google.monitoring.v3.CreateMetricDescriptorRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L293}
  ///
  // clang-format on
  StatusOr<google::api::MetricDescriptor> CreateMetricDescriptor(
      google::monitoring::v3::CreateMetricDescriptorRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a metric descriptor. Only user-created
  /// [custom metrics](https://cloud.google.com/monitoring/custom-metrics) can be
  /// deleted.
  ///
  /// @param name  Required. The metric descriptor on which to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]/metricDescriptors/[METRIC_ID]
  ///  @n
  ///  An example of `[METRIC_ID]` is:
  ///  `"custom.googleapis.com/my_test_metric"`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.DeleteMetricDescriptorRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L311}
  ///
  // clang-format on
  Status DeleteMetricDescriptor(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a metric descriptor. Only user-created
  /// [custom metrics](https://cloud.google.com/monitoring/custom-metrics) can be
  /// deleted.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.DeleteMetricDescriptorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.DeleteMetricDescriptorRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L311}
  ///
  // clang-format on
  Status DeleteMetricDescriptor(
      google::monitoring::v3::DeleteMetricDescriptorRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists time series that match a filter. This method does not require a Workspace.
  ///
  /// @param name  Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name),
  ///  organization or folder on which to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]
  ///      organizations/[ORGANIZATION_ID]
  ///      folders/[FOLDER_ID]
  /// @param filter  Required. A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  ///  that specifies which time series should be returned.  The filter must
  ///  specify a single metric type, and can additionally specify metric labels
  ///  and other information. For example:
  ///  @n
  ///      metric.type = "compute.googleapis.com/instance/cpu/usage_time" AND
  ///          metric.labels.instance_name = "my-instance-name"
  /// @param interval  Required. The time interval for which results should be returned. Only time series
  ///  that contain data points in the specified interval are included
  ///  in the response.
  /// @param view  Required. Specifies which information is returned about the time series.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.monitoring.v3.TimeSeries], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.ListTimeSeriesRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L327}
  /// [google.monitoring.v3.TimeSeries]: @googleapis_reference_link{google/monitoring/v3/metric.proto#L53}
  ///
  // clang-format on
  StreamRange<google::monitoring::v3::TimeSeries> ListTimeSeries(
      std::string const& name, std::string const& filter,
      google::monitoring::v3::TimeInterval const& interval,
      google::monitoring::v3::ListTimeSeriesRequest::TimeSeriesView view,
      Options opts = {});

  // clang-format off
  ///
  /// Lists time series that match a filter. This method does not require a Workspace.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.ListTimeSeriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.monitoring.v3.TimeSeries], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.ListTimeSeriesRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L327}
  /// [google.monitoring.v3.TimeSeries]: @googleapis_reference_link{google/monitoring/v3/metric.proto#L53}
  ///
  // clang-format on
  StreamRange<google::monitoring::v3::TimeSeries> ListTimeSeries(
      google::monitoring::v3::ListTimeSeriesRequest request, Options opts = {});

  // clang-format off
  ///
  /// Creates or adds data to one or more time series.
  /// The response is empty if all time series in the request were written.
  /// If any time series could not be written, a corresponding failure message is
  /// included in the error response.
  ///
  /// @param name  Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name) on
  ///  which to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]
  /// @param time_series  Required. The new data to be added to a list of time series.
  ///  Adds at most one data point to each of several time series.  The new data
  ///  point must be more recent than any other point in its time series.  Each
  ///  `TimeSeries` value must fully specify a unique time series by supplying
  ///  all label values for the metric and the monitored resource.
  ///  @n
  ///  The maximum number of `TimeSeries` objects per `Create` request is 200.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.CreateTimeSeriesRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L421}
  ///
  // clang-format on
  Status CreateTimeSeries(
      std::string const& name,
      std::vector<google::monitoring::v3::TimeSeries> const& time_series,
      Options opts = {});

  // clang-format off
  ///
  /// Creates or adds data to one or more time series.
  /// The response is empty if all time series in the request were written.
  /// If any time series could not be written, a corresponding failure message is
  /// included in the error response.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.CreateTimeSeriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.CreateTimeSeriesRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L421}
  ///
  // clang-format on
  Status CreateTimeSeries(
      google::monitoring::v3::CreateTimeSeriesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates or adds data to one or more service time series. A service time
  /// series is a time series for a metric from a Google Cloud service. The
  /// response is empty if all time series in the request were written. If any
  /// time series could not be written, a corresponding failure message is
  /// included in the error response. This endpoint rejects writes to
  /// user-defined metrics.
  /// This method is only for use by Google Cloud services. Use
  /// [projects.timeSeries.create][google.monitoring.v3.MetricService.CreateTimeSeries]
  /// instead.
  ///
  /// @param name  Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name) on
  ///  which to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]
  /// @param time_series  Required. The new data to be added to a list of time series.
  ///  Adds at most one data point to each of several time series.  The new data
  ///  point must be more recent than any other point in its time series.  Each
  ///  `TimeSeries` value must fully specify a unique time series by supplying
  ///  all label values for the metric and the monitored resource.
  ///  @n
  ///  The maximum number of `TimeSeries` objects per `Create` request is 200.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.CreateTimeSeriesRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L421}
  /// [google.monitoring.v3.MetricService.CreateTimeSeries]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L148}
  ///
  // clang-format on
  Status CreateServiceTimeSeries(
      std::string const& name,
      std::vector<google::monitoring::v3::TimeSeries> const& time_series,
      Options opts = {});

  // clang-format off
  ///
  /// Creates or adds data to one or more service time series. A service time
  /// series is a time series for a metric from a Google Cloud service. The
  /// response is empty if all time series in the request were written. If any
  /// time series could not be written, a corresponding failure message is
  /// included in the error response. This endpoint rejects writes to
  /// user-defined metrics.
  /// This method is only for use by Google Cloud services. Use
  /// [projects.timeSeries.create][google.monitoring.v3.MetricService.CreateTimeSeries]
  /// instead.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.CreateTimeSeriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.CreateTimeSeriesRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L421}
  /// [google.monitoring.v3.MetricService.CreateTimeSeries]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L148}
  ///
  // clang-format on
  Status CreateServiceTimeSeries(
      google::monitoring::v3::CreateTimeSeriesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates or adds data to one or more time series.
  /// The response is empty if all time series in the request were written.
  /// If any time series could not be written, a corresponding failure message is
  /// included in the error response.
  ///
  /// @param name  Required. The [project](https://cloud.google.com/monitoring/api/v3#project_name) on
  ///  which to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]
  /// @param time_series  Required. The new data to be added to a list of time series.
  ///  Adds at most one data point to each of several time series.  The new data
  ///  point must be more recent than any other point in its time series.  Each
  ///  `TimeSeries` value must fully specify a unique time series by supplying
  ///  all label values for the metric and the monitored resource.
  ///  @n
  ///  The maximum number of `TimeSeries` objects per `Create` request is 200.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.CreateTimeSeriesRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L421}
  ///
  // clang-format on
  future<Status> AsyncCreateTimeSeries(
      std::string const& name,
      std::vector<google::monitoring::v3::TimeSeries> const& time_series,
      Options opts = {});

  // clang-format off
  ///
  /// Creates or adds data to one or more time series.
  /// The response is empty if all time series in the request were written.
  /// If any time series could not be written, a corresponding failure message is
  /// included in the error response.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.CreateTimeSeriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.CreateTimeSeriesRequest]: @googleapis_reference_link{google/monitoring/v3/metric_service.proto#L421}
  ///
  // clang-format on
  future<Status> AsyncCreateTimeSeries(
      google::monitoring::v3::CreateTimeSeriesRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<MetricServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_METRIC_CLIENT_H
