// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_INTERNAL_LOGGING_SERVICE_V2_AUTH_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_INTERNAL_LOGGING_SERVICE_V2_AUTH_DECORATOR_H

#include "google/cloud/logging/v2/internal/logging_service_v2_stub.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include "google/cloud/version.h"
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace logging_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class LoggingServiceV2Auth : public LoggingServiceV2Stub {
 public:
  ~LoggingServiceV2Auth() override = default;
  LoggingServiceV2Auth(
      std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
      std::shared_ptr<LoggingServiceV2Stub> child);

  Status DeleteLog(
      grpc::ClientContext& context,
      google::logging::v2::DeleteLogRequest const& request) override;

  StatusOr<google::logging::v2::WriteLogEntriesResponse> WriteLogEntries(
      grpc::ClientContext& context,
      google::logging::v2::WriteLogEntriesRequest const& request) override;

  StatusOr<google::logging::v2::ListLogEntriesResponse> ListLogEntries(
      grpc::ClientContext& context,
      google::logging::v2::ListLogEntriesRequest const& request) override;

  StatusOr<google::logging::v2::ListMonitoredResourceDescriptorsResponse>
  ListMonitoredResourceDescriptors(
      grpc::ClientContext& context,
      google::logging::v2::ListMonitoredResourceDescriptorsRequest const&
          request) override;

  StatusOr<google::logging::v2::ListLogsResponse> ListLogs(
      grpc::ClientContext& context,
      google::logging::v2::ListLogsRequest const& request) override;

  std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::logging::v2::TailLogEntriesRequest,
      google::logging::v2::TailLogEntriesResponse>>
  AsyncTailLogEntries(google::cloud::CompletionQueue const& cq,
                      std::shared_ptr<grpc::ClientContext> context) override;

  future<StatusOr<google::logging::v2::WriteLogEntriesResponse>>
  AsyncWriteLogEntries(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::logging::v2::WriteLogEntriesRequest const& request) override;

 private:
  std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth_;
  std::shared_ptr<LoggingServiceV2Stub> child_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_INTERNAL_LOGGING_SERVICE_V2_AUTH_DECORATOR_H
