// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/edgenetwork/v1/service.proto

#include "google/cloud/edgenetwork/v1/edge_network_connection.h"
#include "google/cloud/edgenetwork/v1/edge_network_options.h"
#include "google/cloud/edgenetwork/v1/internal/edge_network_connection_impl.h"
#include "google/cloud/edgenetwork/v1/internal/edge_network_option_defaults.h"
#include "google/cloud/edgenetwork/v1/internal/edge_network_stub_factory.h"
#include "google/cloud/edgenetwork/v1/internal/edge_network_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace edgenetwork_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EdgeNetworkConnection::~EdgeNetworkConnection() = default;

StatusOr<google::cloud::edgenetwork::v1::InitializeZoneResponse>
EdgeNetworkConnection::InitializeZone(
    google::cloud::edgenetwork::v1::InitializeZoneRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::edgenetwork::v1::Zone>
EdgeNetworkConnection::ListZones(
    google::cloud::edgenetwork::v1::
        ListZonesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::edgenetwork::v1::Zone>>();
}

StatusOr<google::cloud::edgenetwork::v1::Zone> EdgeNetworkConnection::GetZone(
    google::cloud::edgenetwork::v1::GetZoneRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::edgenetwork::v1::Network>
EdgeNetworkConnection::ListNetworks(
    google::cloud::edgenetwork::v1::
        ListNetworksRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::edgenetwork::v1::Network>>();
}

StatusOr<google::cloud::edgenetwork::v1::Network>
EdgeNetworkConnection::GetNetwork(
    google::cloud::edgenetwork::v1::GetNetworkRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::edgenetwork::v1::DiagnoseNetworkResponse>
EdgeNetworkConnection::DiagnoseNetwork(
    google::cloud::edgenetwork::v1::DiagnoseNetworkRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::edgenetwork::v1::Network>>
EdgeNetworkConnection::CreateNetwork(
    google::cloud::edgenetwork::v1::CreateNetworkRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::edgenetwork::v1::Network>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>
EdgeNetworkConnection::DeleteNetwork(
    google::cloud::edgenetwork::v1::DeleteNetworkRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::edgenetwork::v1::Subnet>
EdgeNetworkConnection::ListSubnets(
    google::cloud::edgenetwork::v1::
        ListSubnetsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::edgenetwork::v1::Subnet>>();
}

StatusOr<google::cloud::edgenetwork::v1::Subnet>
EdgeNetworkConnection::GetSubnet(
    google::cloud::edgenetwork::v1::GetSubnetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::edgenetwork::v1::Subnet>>
EdgeNetworkConnection::CreateSubnet(
    google::cloud::edgenetwork::v1::CreateSubnetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::edgenetwork::v1::Subnet>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::edgenetwork::v1::Subnet>>
EdgeNetworkConnection::UpdateSubnet(
    google::cloud::edgenetwork::v1::UpdateSubnetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::edgenetwork::v1::Subnet>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>
EdgeNetworkConnection::DeleteSubnet(
    google::cloud::edgenetwork::v1::DeleteSubnetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::edgenetwork::v1::Interconnect>
EdgeNetworkConnection::ListInterconnects(
    google::cloud::edgenetwork::v1::
        ListInterconnectsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::edgenetwork::v1::Interconnect>>();
}

StatusOr<google::cloud::edgenetwork::v1::Interconnect>
EdgeNetworkConnection::GetInterconnect(
    google::cloud::edgenetwork::v1::GetInterconnectRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::edgenetwork::v1::DiagnoseInterconnectResponse>
EdgeNetworkConnection::DiagnoseInterconnect(
    google::cloud::edgenetwork::v1::DiagnoseInterconnectRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::edgenetwork::v1::InterconnectAttachment>
EdgeNetworkConnection::ListInterconnectAttachments(
    google::cloud::edgenetwork::v1::
        ListInterconnectAttachmentsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::edgenetwork::v1::InterconnectAttachment>>();
}

StatusOr<google::cloud::edgenetwork::v1::InterconnectAttachment>
EdgeNetworkConnection::GetInterconnectAttachment(
    google::cloud::edgenetwork::v1::GetInterconnectAttachmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::edgenetwork::v1::InterconnectAttachment>>
EdgeNetworkConnection::CreateInterconnectAttachment(
    google::cloud::edgenetwork::v1::
        CreateInterconnectAttachmentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::edgenetwork::v1::InterconnectAttachment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>
EdgeNetworkConnection::DeleteInterconnectAttachment(
    google::cloud::edgenetwork::v1::
        DeleteInterconnectAttachmentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::edgenetwork::v1::Router>
EdgeNetworkConnection::ListRouters(
    google::cloud::edgenetwork::v1::
        ListRoutersRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::edgenetwork::v1::Router>>();
}

StatusOr<google::cloud::edgenetwork::v1::Router>
EdgeNetworkConnection::GetRouter(
    google::cloud::edgenetwork::v1::GetRouterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::edgenetwork::v1::DiagnoseRouterResponse>
EdgeNetworkConnection::DiagnoseRouter(
    google::cloud::edgenetwork::v1::DiagnoseRouterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::edgenetwork::v1::Router>>
EdgeNetworkConnection::CreateRouter(
    google::cloud::edgenetwork::v1::CreateRouterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::edgenetwork::v1::Router>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::edgenetwork::v1::Router>>
EdgeNetworkConnection::UpdateRouter(
    google::cloud::edgenetwork::v1::UpdateRouterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::edgenetwork::v1::Router>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>
EdgeNetworkConnection::DeleteRouter(
    google::cloud::edgenetwork::v1::DeleteRouterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<EdgeNetworkConnection> MakeEdgeNetworkConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 EdgeNetworkPolicyOptionList>(options,
                                                              __func__);
  options =
      edgenetwork_v1_internal::EdgeNetworkDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = edgenetwork_v1_internal::CreateDefaultEdgeNetworkStub(
      background->cq(), options);
  return edgenetwork_v1_internal::MakeEdgeNetworkTracingConnection(
      std::make_shared<edgenetwork_v1_internal::EdgeNetworkConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace edgenetwork_v1
}  // namespace cloud
}  // namespace google
