// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/v1/datastore.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_V1_INTERNAL_DATASTORE_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_V1_INTERNAL_DATASTORE_TRACING_CONNECTION_H

#include "google/cloud/datastore/v1/datastore_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace datastore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class DatastoreTracingConnection : public datastore_v1::DatastoreConnection {
 public:
  ~DatastoreTracingConnection() override = default;

  explicit DatastoreTracingConnection(
      std::shared_ptr<datastore_v1::DatastoreConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::datastore::v1::LookupResponse> Lookup(
      google::datastore::v1::LookupRequest const& request) override;

  StatusOr<google::datastore::v1::RunQueryResponse> RunQuery(
      google::datastore::v1::RunQueryRequest const& request) override;

  StatusOr<google::datastore::v1::RunAggregationQueryResponse>
  RunAggregationQuery(google::datastore::v1::RunAggregationQueryRequest const&
                          request) override;

  StatusOr<google::datastore::v1::BeginTransactionResponse> BeginTransaction(
      google::datastore::v1::BeginTransactionRequest const& request) override;

  StatusOr<google::datastore::v1::CommitResponse> Commit(
      google::datastore::v1::CommitRequest const& request) override;

  StatusOr<google::datastore::v1::RollbackResponse> Rollback(
      google::datastore::v1::RollbackRequest const& request) override;

  StatusOr<google::datastore::v1::AllocateIdsResponse> AllocateIds(
      google::datastore::v1::AllocateIdsRequest const& request) override;

  StatusOr<google::datastore::v1::ReserveIdsResponse> ReserveIds(
      google::datastore::v1::ReserveIdsRequest const& request) override;

 private:
  std::shared_ptr<datastore_v1::DatastoreConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<datastore_v1::DatastoreConnection>
MakeDatastoreTracingConnection(
    std::shared_ptr<datastore_v1::DatastoreConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_V1_INTERNAL_DATASTORE_TRACING_CONNECTION_H
