// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceLogTargetPeerOKCode is the HTTP code returned for type ReplaceLogTargetPeerOK
const ReplaceLogTargetPeerOKCode int = 200

/*
ReplaceLogTargetPeerOK Log Target replaced

swagger:response replaceLogTargetPeerOK
*/
type ReplaceLogTargetPeerOK struct {

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewReplaceLogTargetPeerOK creates ReplaceLogTargetPeerOK with default headers values
func NewReplaceLogTargetPeerOK() *ReplaceLogTargetPeerOK {

	return &ReplaceLogTargetPeerOK{}
}

// WithPayload adds the payload to the replace log target peer o k response
func (o *ReplaceLogTargetPeerOK) WithPayload(payload *models.LogTarget) *ReplaceLogTargetPeerOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target peer o k response
func (o *ReplaceLogTargetPeerOK) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetPeerOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetPeerAcceptedCode is the HTTP code returned for type ReplaceLogTargetPeerAccepted
const ReplaceLogTargetPeerAcceptedCode int = 202

/*
ReplaceLogTargetPeerAccepted Configuration change accepted and reload requested

swagger:response replaceLogTargetPeerAccepted
*/
type ReplaceLogTargetPeerAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewReplaceLogTargetPeerAccepted creates ReplaceLogTargetPeerAccepted with default headers values
func NewReplaceLogTargetPeerAccepted() *ReplaceLogTargetPeerAccepted {

	return &ReplaceLogTargetPeerAccepted{}
}

// WithReloadID adds the reloadId to the replace log target peer accepted response
func (o *ReplaceLogTargetPeerAccepted) WithReloadID(reloadID string) *ReplaceLogTargetPeerAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace log target peer accepted response
func (o *ReplaceLogTargetPeerAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace log target peer accepted response
func (o *ReplaceLogTargetPeerAccepted) WithPayload(payload *models.LogTarget) *ReplaceLogTargetPeerAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target peer accepted response
func (o *ReplaceLogTargetPeerAccepted) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetPeerAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetPeerBadRequestCode is the HTTP code returned for type ReplaceLogTargetPeerBadRequest
const ReplaceLogTargetPeerBadRequestCode int = 400

/*
ReplaceLogTargetPeerBadRequest Bad request

swagger:response replaceLogTargetPeerBadRequest
*/
type ReplaceLogTargetPeerBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetPeerBadRequest creates ReplaceLogTargetPeerBadRequest with default headers values
func NewReplaceLogTargetPeerBadRequest() *ReplaceLogTargetPeerBadRequest {

	return &ReplaceLogTargetPeerBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log target peer bad request response
func (o *ReplaceLogTargetPeerBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetPeerBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target peer bad request response
func (o *ReplaceLogTargetPeerBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target peer bad request response
func (o *ReplaceLogTargetPeerBadRequest) WithPayload(payload *models.Error) *ReplaceLogTargetPeerBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target peer bad request response
func (o *ReplaceLogTargetPeerBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetPeerBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetPeerNotFoundCode is the HTTP code returned for type ReplaceLogTargetPeerNotFound
const ReplaceLogTargetPeerNotFoundCode int = 404

/*
ReplaceLogTargetPeerNotFound The specified resource was not found

swagger:response replaceLogTargetPeerNotFound
*/
type ReplaceLogTargetPeerNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetPeerNotFound creates ReplaceLogTargetPeerNotFound with default headers values
func NewReplaceLogTargetPeerNotFound() *ReplaceLogTargetPeerNotFound {

	return &ReplaceLogTargetPeerNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log target peer not found response
func (o *ReplaceLogTargetPeerNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetPeerNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target peer not found response
func (o *ReplaceLogTargetPeerNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target peer not found response
func (o *ReplaceLogTargetPeerNotFound) WithPayload(payload *models.Error) *ReplaceLogTargetPeerNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target peer not found response
func (o *ReplaceLogTargetPeerNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetPeerNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceLogTargetPeerDefault General Error

swagger:response replaceLogTargetPeerDefault
*/
type ReplaceLogTargetPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetPeerDefault creates ReplaceLogTargetPeerDefault with default headers values
func NewReplaceLogTargetPeerDefault(code int) *ReplaceLogTargetPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceLogTargetPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace log target peer default response
func (o *ReplaceLogTargetPeerDefault) WithStatusCode(code int) *ReplaceLogTargetPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace log target peer default response
func (o *ReplaceLogTargetPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace log target peer default response
func (o *ReplaceLogTargetPeerDefault) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target peer default response
func (o *ReplaceLogTargetPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target peer default response
func (o *ReplaceLogTargetPeerDefault) WithPayload(payload *models.Error) *ReplaceLogTargetPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target peer default response
func (o *ReplaceLogTargetPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
