// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package filter

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllFilterFrontendOKCode is the HTTP code returned for type GetAllFilterFrontendOK
const GetAllFilterFrontendOKCode int = 200

/*
GetAllFilterFrontendOK Successful operation

swagger:response getAllFilterFrontendOK
*/
type GetAllFilterFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.Filters `json:"body,omitempty"`
}

// NewGetAllFilterFrontendOK creates GetAllFilterFrontendOK with default headers values
func NewGetAllFilterFrontendOK() *GetAllFilterFrontendOK {

	return &GetAllFilterFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all filter frontend o k response
func (o *GetAllFilterFrontendOK) WithConfigurationVersion(configurationVersion string) *GetAllFilterFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all filter frontend o k response
func (o *GetAllFilterFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all filter frontend o k response
func (o *GetAllFilterFrontendOK) WithPayload(payload models.Filters) *GetAllFilterFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all filter frontend o k response
func (o *GetAllFilterFrontendOK) SetPayload(payload models.Filters) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllFilterFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Filters{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllFilterFrontendDefault General Error

swagger:response getAllFilterFrontendDefault
*/
type GetAllFilterFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllFilterFrontendDefault creates GetAllFilterFrontendDefault with default headers values
func NewGetAllFilterFrontendDefault(code int) *GetAllFilterFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllFilterFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all filter frontend default response
func (o *GetAllFilterFrontendDefault) WithStatusCode(code int) *GetAllFilterFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all filter frontend default response
func (o *GetAllFilterFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all filter frontend default response
func (o *GetAllFilterFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetAllFilterFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all filter frontend default response
func (o *GetAllFilterFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all filter frontend default response
func (o *GetAllFilterFrontendDefault) WithPayload(payload *models.Error) *GetAllFilterFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all filter frontend default response
func (o *GetAllFilterFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllFilterFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
