// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/agent.proto

#include "google/cloud/dialogflow_cx/agents_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AgentsConnectionIdempotencyPolicy::~AgentsConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<AgentsConnectionIdempotencyPolicy>
AgentsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<AgentsConnectionIdempotencyPolicy>(*this);
}

Idempotency AgentsConnectionIdempotencyPolicy::ListAgents(
    google::cloud::dialogflow::cx::v3::ListAgentsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::GetAgent(
    google::cloud::dialogflow::cx::v3::GetAgentRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::CreateAgent(
    google::cloud::dialogflow::cx::v3::CreateAgentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::UpdateAgent(
    google::cloud::dialogflow::cx::v3::UpdateAgentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::DeleteAgent(
    google::cloud::dialogflow::cx::v3::DeleteAgentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::ExportAgent(
    google::cloud::dialogflow::cx::v3::ExportAgentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::RestoreAgent(
    google::cloud::dialogflow::cx::v3::RestoreAgentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::ValidateAgent(
    google::cloud::dialogflow::cx::v3::ValidateAgentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::GetAgentValidationResult(
    google::cloud::dialogflow::cx::v3::GetAgentValidationResultRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::GetGenerativeSettings(
    google::cloud::dialogflow::cx::v3::GetGenerativeSettingsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AgentsConnectionIdempotencyPolicy::UpdateGenerativeSettings(
    google::cloud::dialogflow::cx::v3::UpdateGenerativeSettingsRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<AgentsConnectionIdempotencyPolicy>
MakeDefaultAgentsConnectionIdempotencyPolicy() {
  return std::make_unique<AgentsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
