// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/machine_images/v1/machine_images.proto

#include "google/cloud/compute/machine_images/v1/machine_images_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_machine_images_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

MachineImagesConnectionIdempotencyPolicy::
    ~MachineImagesConnectionIdempotencyPolicy() = default;

std::unique_ptr<MachineImagesConnectionIdempotencyPolicy>
MachineImagesConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<MachineImagesConnectionIdempotencyPolicy>(*this);
}

Idempotency MachineImagesConnectionIdempotencyPolicy::DeleteMachineImage(
    google::cloud::cpp::compute::machine_images::v1::
        DeleteMachineImageRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MachineImagesConnectionIdempotencyPolicy::GetMachineImage(
    google::cloud::cpp::compute::machine_images::v1::
        GetMachineImageRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency MachineImagesConnectionIdempotencyPolicy::GetIamPolicy(
    google::cloud::cpp::compute::machine_images::v1::
        GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency MachineImagesConnectionIdempotencyPolicy::InsertMachineImage(
    google::cloud::cpp::compute::machine_images::v1::
        InsertMachineImageRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MachineImagesConnectionIdempotencyPolicy::ListMachineImages(
    google::cloud::cpp::compute::machine_images::v1::
        ListMachineImagesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency MachineImagesConnectionIdempotencyPolicy::SetIamPolicy(
    google::cloud::cpp::compute::machine_images::v1::
        SetIamPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MachineImagesConnectionIdempotencyPolicy::TestIamPermissions(
    google::cloud::cpp::compute::machine_images::v1::
        TestIamPermissionsRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<MachineImagesConnectionIdempotencyPolicy>
MakeDefaultMachineImagesConnectionIdempotencyPolicy() {
  return std::make_unique<MachineImagesConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_machine_images_v1
}  // namespace cloud
}  // namespace google
