// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/cloudquotas/v1/cloudquotas.proto

#include "google/cloud/cloudquotas/v1/internal/cloud_quotas_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudquotas_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CloudQuotasTracingConnection::CloudQuotasTracingConnection(
    std::shared_ptr<cloudquotas_v1::CloudQuotasConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::api::cloudquotas::v1::QuotaInfo>
CloudQuotasTracingConnection::ListQuotaInfos(
    google::api::cloudquotas::v1::ListQuotaInfosRequest request) {
  auto span = internal::MakeSpan(
      "cloudquotas_v1::CloudQuotasConnection::ListQuotaInfos");
  internal::OTelScope scope(span);
  auto sr = child_->ListQuotaInfos(std::move(request));
  return internal::MakeTracedStreamRange<
      google::api::cloudquotas::v1::QuotaInfo>(std::move(span), std::move(sr));
}

StatusOr<google::api::cloudquotas::v1::QuotaInfo>
CloudQuotasTracingConnection::GetQuotaInfo(
    google::api::cloudquotas::v1::GetQuotaInfoRequest const& request) {
  auto span =
      internal::MakeSpan("cloudquotas_v1::CloudQuotasConnection::GetQuotaInfo");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetQuotaInfo(request));
}

StreamRange<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasTracingConnection::ListQuotaPreferences(
    google::api::cloudquotas::v1::ListQuotaPreferencesRequest request) {
  auto span = internal::MakeSpan(
      "cloudquotas_v1::CloudQuotasConnection::ListQuotaPreferences");
  internal::OTelScope scope(span);
  auto sr = child_->ListQuotaPreferences(std::move(request));
  return internal::MakeTracedStreamRange<
      google::api::cloudquotas::v1::QuotaPreference>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasTracingConnection::GetQuotaPreference(
    google::api::cloudquotas::v1::GetQuotaPreferenceRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudquotas_v1::CloudQuotasConnection::GetQuotaPreference");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetQuotaPreference(request));
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasTracingConnection::CreateQuotaPreference(
    google::api::cloudquotas::v1::CreateQuotaPreferenceRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudquotas_v1::CloudQuotasConnection::CreateQuotaPreference");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateQuotaPreference(request));
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasTracingConnection::UpdateQuotaPreference(
    google::api::cloudquotas::v1::UpdateQuotaPreferenceRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudquotas_v1::CloudQuotasConnection::UpdateQuotaPreference");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateQuotaPreference(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<cloudquotas_v1::CloudQuotasConnection>
MakeCloudQuotasTracingConnection(
    std::shared_ptr<cloudquotas_v1::CloudQuotasConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<CloudQuotasTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudquotas_v1_internal
}  // namespace cloud
}  // namespace google
