// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceHTTPCheckBackendOKCode is the HTTP code returned for type ReplaceHTTPCheckBackendOK
const ReplaceHTTPCheckBackendOKCode int = 200

/*
ReplaceHTTPCheckBackendOK HTTP check replaced

swagger:response replaceHttpCheckBackendOK
*/
type ReplaceHTTPCheckBackendOK struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPCheck `json:"body,omitempty"`
}

// NewReplaceHTTPCheckBackendOK creates ReplaceHTTPCheckBackendOK with default headers values
func NewReplaceHTTPCheckBackendOK() *ReplaceHTTPCheckBackendOK {

	return &ReplaceHTTPCheckBackendOK{}
}

// WithPayload adds the payload to the replace Http check backend o k response
func (o *ReplaceHTTPCheckBackendOK) WithPayload(payload *models.HTTPCheck) *ReplaceHTTPCheckBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http check backend o k response
func (o *ReplaceHTTPCheckBackendOK) SetPayload(payload *models.HTTPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPCheckBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPCheckBackendAcceptedCode is the HTTP code returned for type ReplaceHTTPCheckBackendAccepted
const ReplaceHTTPCheckBackendAcceptedCode int = 202

/*
ReplaceHTTPCheckBackendAccepted Configuration change accepted and reload requested

swagger:response replaceHttpCheckBackendAccepted
*/
type ReplaceHTTPCheckBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPCheck `json:"body,omitempty"`
}

// NewReplaceHTTPCheckBackendAccepted creates ReplaceHTTPCheckBackendAccepted with default headers values
func NewReplaceHTTPCheckBackendAccepted() *ReplaceHTTPCheckBackendAccepted {

	return &ReplaceHTTPCheckBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace Http check backend accepted response
func (o *ReplaceHTTPCheckBackendAccepted) WithReloadID(reloadID string) *ReplaceHTTPCheckBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Http check backend accepted response
func (o *ReplaceHTTPCheckBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Http check backend accepted response
func (o *ReplaceHTTPCheckBackendAccepted) WithPayload(payload *models.HTTPCheck) *ReplaceHTTPCheckBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http check backend accepted response
func (o *ReplaceHTTPCheckBackendAccepted) SetPayload(payload *models.HTTPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPCheckBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPCheckBackendBadRequestCode is the HTTP code returned for type ReplaceHTTPCheckBackendBadRequest
const ReplaceHTTPCheckBackendBadRequestCode int = 400

/*
ReplaceHTTPCheckBackendBadRequest Bad request

swagger:response replaceHttpCheckBackendBadRequest
*/
type ReplaceHTTPCheckBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPCheckBackendBadRequest creates ReplaceHTTPCheckBackendBadRequest with default headers values
func NewReplaceHTTPCheckBackendBadRequest() *ReplaceHTTPCheckBackendBadRequest {

	return &ReplaceHTTPCheckBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http check backend bad request response
func (o *ReplaceHTTPCheckBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPCheckBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http check backend bad request response
func (o *ReplaceHTTPCheckBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http check backend bad request response
func (o *ReplaceHTTPCheckBackendBadRequest) WithPayload(payload *models.Error) *ReplaceHTTPCheckBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http check backend bad request response
func (o *ReplaceHTTPCheckBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPCheckBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPCheckBackendNotFoundCode is the HTTP code returned for type ReplaceHTTPCheckBackendNotFound
const ReplaceHTTPCheckBackendNotFoundCode int = 404

/*
ReplaceHTTPCheckBackendNotFound The specified resource was not found

swagger:response replaceHttpCheckBackendNotFound
*/
type ReplaceHTTPCheckBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPCheckBackendNotFound creates ReplaceHTTPCheckBackendNotFound with default headers values
func NewReplaceHTTPCheckBackendNotFound() *ReplaceHTTPCheckBackendNotFound {

	return &ReplaceHTTPCheckBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http check backend not found response
func (o *ReplaceHTTPCheckBackendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPCheckBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http check backend not found response
func (o *ReplaceHTTPCheckBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http check backend not found response
func (o *ReplaceHTTPCheckBackendNotFound) WithPayload(payload *models.Error) *ReplaceHTTPCheckBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http check backend not found response
func (o *ReplaceHTTPCheckBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPCheckBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceHTTPCheckBackendDefault General Error

swagger:response replaceHttpCheckBackendDefault
*/
type ReplaceHTTPCheckBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPCheckBackendDefault creates ReplaceHTTPCheckBackendDefault with default headers values
func NewReplaceHTTPCheckBackendDefault(code int) *ReplaceHTTPCheckBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceHTTPCheckBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace HTTP check backend default response
func (o *ReplaceHTTPCheckBackendDefault) WithStatusCode(code int) *ReplaceHTTPCheckBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace HTTP check backend default response
func (o *ReplaceHTTPCheckBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace HTTP check backend default response
func (o *ReplaceHTTPCheckBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPCheckBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace HTTP check backend default response
func (o *ReplaceHTTPCheckBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace HTTP check backend default response
func (o *ReplaceHTTPCheckBackendDefault) WithPayload(payload *models.Error) *ReplaceHTTPCheckBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace HTTP check backend default response
func (o *ReplaceHTTPCheckBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPCheckBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
