/* ====================================================================
 * Copyright (c) 2002 Johnny Shelley.  All rights reserved.
 *
 * Bcrypt is licensed under the BSD software license. See the file 
 * called 'LICENSE' that you should have received with this software
 * for details
 * ====================================================================
 */

#include "includes.h"
#include "defines.h"
#include "functions.h"

#define endianBig ((uint8_t) 0x45)
#define endianLittle ((uint8_t) 0x54)

void getEndian(uint8_t **e) {
  uint16_t i = 0x4321;
  int bigE = (*(uint8_t*) &i);

  if ((*e = realloc(*e, sizeof(uint8_t) + 1)) == NULL)
    memerror();

  memset(*e, 0, sizeof(uint8_t) + 1);

  if (bigE == 0x43)
    memset(*e, endianBig, 1);
  else if (bigE == 0x21)
    memset(*e, endianLittle, 1);
}

uint32_t swapEndian(uint32_t value) {
  uint32_t b1, b2, b3, b4;
  uint32_t swapped;

  b4 = (value>>24) & 0xff;
  b3 = (value>>16) & 0xff;
  b2 = (value>>8) & 0xff;
  b1 = value & 0xff;

  swapped = (b1<<24) | (b2<<16) | (b3<<8) | b4;
  return(swapped);
}

int testEndian(uint8_t *input) {
  uint8_t *myEndian = NULL, *yourEndian = NULL;

  getEndian(&myEndian);
  if ((yourEndian = malloc(2)) == NULL)
    memerror();

  memset(yourEndian, 0, 2);
  memcpy(yourEndian, input, 1);

  if (memcmp(myEndian, yourEndian, 1) == 0) {
    free(myEndian);
    free(yourEndian);
    return(0);
  }

  free(myEndian);
  free(yourEndian);
  return(1);
}

int swapCompressed(uint8_t **input, uLong sz) {
  uint8_t c;
  uint32_t j, swap;

  memcpy(&c, *input+1, 1);

  if (c == 0)
    return(0);

  j = sizeof(uint32_t);

  memcpy(&swap, *input+(sz - j), j);
  swap = swapEndian(swap);
  memcpy(*input+(sz - j), &swap, j);

  return(1);
}
