"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = void 0;
const language_service_1 = require("@volar/language-service");
const vue = require("@vue/language-core");
const twoslashReg = /<!--\s*\^\?\s*-->/g;
const plugin = (context, modules) => {
    if (!context || !modules?.typescript)
        return {};
    const ts = modules.typescript;
    return {
        provideInlayHints(document, range) {
            return worker(document.uri, (vueFile) => {
                const hoverOffsets = [];
                const inlayHints = [];
                const languageService = context.inject('typescript/languageService');
                for (const pointer of document.getText(range).matchAll(twoslashReg)) {
                    const offset = pointer.index + pointer[0].indexOf('^?') + document.offsetAt(range.start);
                    const position = document.positionAt(offset);
                    hoverOffsets.push([position, document.offsetAt({
                            line: position.line - 1,
                            character: position.character,
                        })]);
                }
                (0, language_service_1.forEachEmbeddedFile)(vueFile, (embedded) => {
                    if (embedded.kind === language_service_1.FileKind.TypeScriptHostFile) {
                        for (const [_, map] of context.documents.getMapsByVirtualFileName(embedded.fileName)) {
                            for (const [pointerPosition, hoverOffset] of hoverOffsets) {
                                for (const [tsOffset, mapping] of map.map.toGeneratedOffsets(hoverOffset)) {
                                    if (mapping.data.hover) {
                                        const quickInfo = languageService.getQuickInfoAtPosition(embedded.fileName, tsOffset);
                                        if (quickInfo) {
                                            inlayHints.push({
                                                position: { line: pointerPosition.line, character: pointerPosition.character + 2 },
                                                label: ts.displayPartsToString(quickInfo.displayParts),
                                                paddingLeft: true,
                                                paddingRight: false,
                                            });
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    }
                });
                return inlayHints;
            });
        },
    };
    function worker(uri, callback) {
        const [virtualFile] = context.documents.getVirtualFileByUri(uri);
        if (!(virtualFile instanceof vue.VueFile))
            return;
        return callback(virtualFile);
    }
};
const create = () => plugin;
exports.create = create;
//# sourceMappingURL=vue-twoslash-queries.js.map