/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.internal.utility;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.dali.internal.utility.CollectionTools;

public final class XMLStringEncoder {
    private final char[] chars;
    private final char maxChar;

    public XMLStringEncoder(char[] chars) {
        if (chars == null) {
            throw new NullPointerException();
        }
        this.chars = CollectionTools.contains(chars, '&') ? chars : CollectionTools.add(chars, '&');
        this.maxChar = this.calculateMaxInvalidFileNameChar();
    }

    private char calculateMaxInvalidFileNameChar() {
        char[] localChars = this.chars;
        char max = '\u0000';
        int i = localChars.length;
        while (i-- > 0) {
            char c = localChars[i];
            if (max >= c) continue;
            max = c;
        }
        return max;
    }

    public String encode(String s) {
        int len = s.length();
        StringBuffer sb = new StringBuffer(len + 20);
        int i = 0;
        while (i < len) {
            this.appendCharacterTo(s.charAt(i), sb);
            ++i;
        }
        return sb.toString();
    }

    public String decode(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        StringBuffer temp = new StringBuffer();
        this.decodeTo(new StringReader(s), sb, temp);
        return sb.toString();
    }

    private void appendCharacterTo(char c, StringBuffer sb) {
        if (this.charIsToBeEncoded(c)) {
            this.appendCharacterReferenceTo(c, sb);
        } else {
            sb.append(c);
        }
    }

    private boolean charIsToBeEncoded(char c) {
        return c <= this.maxChar && CollectionTools.contains(this.chars, c);
    }

    private void appendCharacterReferenceTo(char c, StringBuffer sb) {
        sb.append("&#x");
        sb.append(Integer.toString(c, 16));
        sb.append(';');
    }

    private void decodeTo(Reader reader, StringBuffer sb, StringBuffer temp) {
        try {
            this.decodeToUnhandled(reader, sb, temp);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void decodeToUnhandled(Reader reader, StringBuffer sb, StringBuffer temp) throws IOException {
        int c = reader.read();
        while (c != -1) {
            if (c == 38) {
                this.decodeCharacterReferenceTo(reader, sb, temp);
            } else {
                sb.append((char)c);
            }
            c = reader.read();
        }
        reader.close();
    }

    private void decodeCharacterReferenceTo(Reader reader, StringBuffer sb, StringBuffer temp) throws IOException {
        int c = reader.read();
        this.checkChar(c, 35);
        c = reader.read();
        this.checkChar(c, 120);
        temp.setLength(0);
        c = reader.read();
        while (c != 59) {
            this.checkEndOfStream(c);
            temp.append((char)c);
            c = reader.read();
        }
        String charValue = temp.toString();
        if (charValue.length() == 0) {
            throw new IllegalStateException("missing numeric string");
        }
        sb.append((char)Integer.parseInt(charValue, 16));
    }

    private void checkChar(int c, int expected) {
        this.checkEndOfStream(c);
        if (c != expected) {
            throw new IllegalStateException("expected '" + (char)expected + "', but encountered '" + (char)c + "'");
        }
    }

    private void checkEndOfStream(int c) {
        if (c == -1) {
            throw new IllegalStateException("unexpected end of string");
        }
    }
}

