/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.AttributeOverride;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.Embeddable;
import org.eclipse.dali.core.Embedded;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.core.adapters.IEmbeddedModelAdapter;
import org.eclipse.dali.core.impl.PersistentAttributeFlavorImpl;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.NullIterator;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class EmbeddedImpl
extends PersistentAttributeFlavorImpl
implements Embedded {
    protected static final boolean DEFAULT_EDEFAULT = true;
    protected boolean default_ = true;
    protected EList attributeOverrides = null;
    static /* synthetic */ Class class$0;

    protected EmbeddedImpl() {
    }

    protected EmbeddedImpl(IEmbeddedModelAdapter modelAdapter, boolean isDefault) {
        super(modelAdapter);
        this.default_ = isDefault;
    }

    protected EClass eStaticClass() {
        return DaliPackage.eINSTANCE.getEmbedded();
    }

    public boolean isDefault() {
        return this.default_;
    }

    public void setDefaultGen(boolean newDefault) {
        boolean oldDefault = this.default_;
        this.default_ = newDefault;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldDefault, this.default_));
        }
    }

    public void setDefault(boolean newDefault) {
        this.setDefaultGen(newDefault);
        ((IEmbeddedModelAdapter)this.getModelAdapter()).defaultChanged();
    }

    public EList getAttributeOverrides() {
        if (this.attributeOverrides == null) {
            this.attributeOverrides = new EObjectContainmentEList(AttributeOverride.class, (InternalEObject)this, 1);
        }
        return this.attributeOverrides;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 1: {
                    return ((InternalEList)this.getAttributeOverrides()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.isDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: {
                return this.getAttributeOverrides();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setDefault((Boolean)newValue);
                return;
            }
            case 1: {
                this.getAttributeOverrides().clear();
                this.getAttributeOverrides().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setDefault(true);
                return;
            }
            case 1: {
                this.getAttributeOverrides().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return !this.default_;
            }
            case 1: {
                return this.attributeOverrides != null && !this.attributeOverrides.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (default: ");
        result.append(this.default_);
        result.append(')');
        return result.toString();
    }

    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.addAttributeOverridesProblemsTo(problems);
    }

    private void addAttributeOverridesProblemsTo(List problems) {
        for (AttributeOverride override : this.getAttributeOverrides()) {
            if (!CollectionTools.contains((Iterator)this.possibleAttributeOverrideNames(), (Object)override.getName())) {
                problems.add(this.buildProblem(this.unresolvedAttributeOverrideMessage(override), this.getTextRange()));
            }
            if (override.columnResolves()) continue;
            problems.add(this.buildProblem(this.unresolvedColumnMessage(override), override.getTextRange()));
        }
    }

    protected String unresolvedColumnMessage(AttributeOverride override) {
        return "Embeddable attribute \"" + override.getName() + "\" mapped to unresolved column \"" + override.getColumn().getName() + "\"";
    }

    protected String unresolvedAttributeOverrideMessage(AttributeOverride override) {
        return "Attribute override \"" + override.getName() + "\" is not a valid Embeddable attribute";
    }

    public String getKey() {
        return "embedded";
    }

    public boolean supportsColumn() {
        return true;
    }

    public Embeddable getEmbeddable() {
        return ((IEmbeddedModelAdapter)this.getModelAdapter()).getEmbeddable();
    }

    public Iterator possibleAttributeOverrideNames() {
        Embeddable embeddable = this.getEmbeddable();
        if (embeddable == null) {
            return NullIterator.instance();
        }
        return new TransformationIterator(this.getEmbeddable().getPersistentType().getPersistentAttributes().iterator()){

            protected Object transform(Object next) {
                return ((PersistentAttribute)next).getName();
            }
        };
    }
}

