/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html;

import java.io.Serializable;
import org.eclipse.vjet.dsf.common.Z;

public interface IConditionalUsage
extends Serializable {
    public static final String DELIMITER = "###";
    public static final Condition IE6 = new IeCondition("IE 6"){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(CLIENT_TYPE type) {
            return CLIENT_TYPE.IE6 == type;
        }
    };
    public static final Condition IE7 = new IeCondition("IE 7"){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(CLIENT_TYPE type) {
            return CLIENT_TYPE.IE7 == type;
        }
    };
    public static final Condition IE8 = new IeCondition("IE 8"){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(CLIENT_TYPE type) {
            return CLIENT_TYPE.IE8 == type;
        }
    };
    public static final Condition NOT_IE6 = new IeCondition("!IE 6"){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(CLIENT_TYPE type) {
            return CLIENT_TYPE.IE6 != type;
        }
    };
    public static final Condition NOT_IE7 = new IeCondition("!IE 7"){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(CLIENT_TYPE type) {
            return CLIENT_TYPE.IE7 != type;
        }
    };
    public static final Condition NOT_IE8 = new IeCondition("!IE 8"){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(CLIENT_TYPE type) {
            return CLIENT_TYPE.IE8 != type;
        }
    };
    public static final Condition BELOW_IE6 = new IeCondition("lt IE 6"){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(CLIENT_TYPE type) {
            return CLIENT_TYPE.IE5 == type;
        }
    };
    public static final Condition BELOW_IE7 = new IeCondition("lt IE 7"){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(CLIENT_TYPE type) {
            return CLIENT_TYPE.IE5 == type || CLIENT_TYPE.IE6 == type;
        }
    };
    public static final Condition BELOW_IE8 = new IeCondition("lt IE 8"){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(CLIENT_TYPE type) {
            return BELOW_IE7.matches(type) || CLIENT_TYPE.IE7 == type;
        }
    };
    public static final Condition IE5_AND_ABOVE = new IeCondition("gte IE 5"){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(CLIENT_TYPE type) {
            return IE6_AND_ABOVE.matches(type) || CLIENT_TYPE.IE5 == type;
        }
    };
    public static final Condition IE6_AND_ABOVE = new IeCondition("gte IE 6"){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(CLIENT_TYPE type) {
            return IE7_AND_ABOVE.matches(type) || CLIENT_TYPE.IE6 == type;
        }
    };
    public static final Condition IE7_AND_ABOVE = new IeCondition("gte IE 7"){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(CLIENT_TYPE type) {
            return CLIENT_TYPE.IE8 == type || CLIENT_TYPE.IE7 == type;
        }
    };

    public Condition getCondition();

    public static enum CLIENT_TYPE {
        IE5,
        IE6,
        IE7,
        IE8,
        OTHER;

    }

    public static abstract class Condition
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String m_begin;
        private final String m_end;
        private final String m_condition;

        public Condition(String begin, String end, String condition) {
            this.m_begin = begin;
            this.m_end = end;
            this.m_condition = condition;
        }

        public String getBegin() {
            return this.m_begin;
        }

        public String getEnd() {
            return this.m_end;
        }

        public String getCondition() {
            return this.m_condition;
        }

        public abstract boolean matches(CLIENT_TYPE var1);

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Condition)) {
                return false;
            }
            Condition other = (Condition)o;
            return this.m_begin.equals(other.m_begin) && this.m_end.equals(other.m_end);
        }

        public String toString() {
            Z z = new Z();
            z.format("begin", (Object)this.getBegin());
            z.format("end", (Object)this.getEnd());
            return z.toString();
        }
    }

    public static class ConditionalSerializer
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public static Condition fromText(String text) {
            if (text.equals("IE 6")) {
                return IE6;
            }
            if (text.equals("IE 7")) {
                return IE7;
            }
            if (text.equals("IE 8")) {
                return IE8;
            }
            if (text.equals("!IE 6")) {
                return NOT_IE6;
            }
            if (text.equals("!IE 7")) {
                return NOT_IE7;
            }
            if (text.equals("!IE 8")) {
                return NOT_IE8;
            }
            if (text.equals("lt IE 6")) {
                return BELOW_IE6;
            }
            if (text.equals("lt IE 7")) {
                return BELOW_IE7;
            }
            if (text.equals("lt IE 8")) {
                return BELOW_IE8;
            }
            if (text.equals("gte IE 5")) {
                return IE5_AND_ABOVE;
            }
            if (text.equals("gte IE 6")) {
                return IE6_AND_ABOVE;
            }
            if (text.equals("gte IE 7")) {
                return IE7_AND_ABOVE;
            }
            return null;
        }

        public static String toText(Condition condition) {
            return new StringBuffer(IConditionalUsage.DELIMITER).append(condition.getCondition()).append(IConditionalUsage.DELIMITER).toString();
        }
    }

    public static abstract class IeCondition
    extends Condition {
        private static final long serialVersionUID = 1L;
        private static final String IE_BEGIN_CONDITION_PRE = "[if ";
        private static final String IE_BEGIN_CONDITION_SUF = "]>";
        private static final String IE_END_CONDITION = "<![endif]";

        public IeCondition(String condition) {
            super(IE_BEGIN_CONDITION_PRE + condition + IE_BEGIN_CONDITION_SUF, IE_END_CONDITION, condition);
        }
    }
}

