/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.spec.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.spec.module.IModuleSpec;
import org.eclipse.vjet.dsf.spec.view.DefaultViewSpec;
import org.eclipse.vjet.dsf.spec.view.IViewSpec;

public class DefaultModuleSpec
implements IModuleSpec {
    private final String m_name;
    private String m_nameSpace;
    private List<IViewSpec> m_viewSpecs = new ArrayList<IViewSpec>(1);
    private List<IModuleSpec> m_childModules;
    private volatile boolean m_initialized = false;

    public DefaultModuleSpec(String name) {
        if (name == null) {
            DsfExceptionHelper.chuck((String)"name is null");
        }
        this.m_name = name;
    }

    public DefaultModuleSpec(String name, String nameSpace) {
        this(name);
        this.m_nameSpace = nameSpace;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getNameSpace() {
        return this.m_nameSpace;
    }

    @Override
    public List<IViewSpec> getAllViewSpecs() {
        this.initialize();
        if (this.m_viewSpecs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_viewSpecs);
    }

    @Override
    public List<IModuleSpec> getChildModules() {
        this.initialize();
        if (this.m_childModules == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_childModules);
    }

    protected IModuleSpec addViewSpec(IViewSpec respSpec) {
        this.m_viewSpecs.add(respSpec);
        return this;
    }

    protected IModuleSpec addChildModule(IModuleSpec moduleSpec) {
        if (this.m_childModules == null) {
            this.m_childModules = new ArrayList<IModuleSpec>(1);
        }
        this.m_childModules.add(moduleSpec);
        return this;
    }

    public DefaultViewSpec createViewSpec(String name) {
        DefaultViewSpec viewSpec = new DefaultViewSpec(name);
        this.addViewSpec(viewSpec);
        return viewSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        if (this.m_initialized) {
            return;
        }
        DefaultModuleSpec defaultModuleSpec = this;
        synchronized (defaultModuleSpec) {
            if (this.m_initialized) {
                return;
            }
            try {
                Class.forName(String.valueOf(this.getClass().getName()) + "$ViewSpecs");
            }
            catch (ClassNotFoundException classNotFoundException) {}
            this.m_initialized = true;
        }
    }
}

