/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsruntime.optimizer;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;
import org.eclipse.vjet.dsf.json.serializer.BeanSerializer;
import org.eclipse.vjet.vsf.jsruntime.optimizer.OptimizerUtil;

public class JavaBeanOptimizer {
    public static final String BEAN_PARAM_PREFIX = "_";
    private Class m_class;
    private Map<String, String> m_data = new HashMap<String, String>();
    private List<String> m_fields = new ArrayList<String>();
    protected Map<String, String> m_shortKeys = new HashMap<String, String>();
    private Map<Object, Map<String, String>> m_beanValuesMap = new HashMap<Object, Map<String, String>>();
    private String m_scope_prefix;
    BeanSerializer.BeanData m_bdata;

    public JavaBeanOptimizer(Object obj, String scopePrefix) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.m_scope_prefix = scopePrefix;
        this.m_class = obj.getClass();
        this.m_bdata = BeanSerializer.getBeanData((Class)this.m_class);
        Object[] args = new Object[]{};
        HashMap<String, String> values = new HashMap<String, String>();
        int i = 0;
        for (Map.Entry entry : this.m_bdata.m_readableProps.entrySet()) {
            Method m = (Method)entry.getValue();
            String key = (String)entry.getKey();
            Object o = m.invoke(obj, args);
            IConverter convert = OptimizerUtil.getDefaultConverter(o);
            IConversionResult result = convert.convert(o);
            values.put(key, (String)result.getValue());
            this.m_data.put(key, (String)result.getValue());
            this.m_fields.add(key);
            this.m_shortKeys.put(key, String.valueOf(this.m_scope_prefix) + BEAN_PARAM_PREFIX + i++);
        }
        this.m_beanValuesMap.put(obj, values);
    }

    public void compare(Object obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null || !obj.getClass().equals(this.m_class)) {
            return;
        }
        Object[] args = new Object[]{};
        HashMap<String, String> values = new HashMap<String, String>();
        for (Map.Entry entry : this.m_bdata.m_readableProps.entrySet()) {
            Method m = (Method)entry.getValue();
            Object o = m.invoke(obj, args);
            IConverter convert = OptimizerUtil.getDefaultConverter(o);
            IConversionResult result = convert.convert(o);
            if (!((String)result.getValue()).equals(this.m_data.get(entry.getKey()))) {
                this.m_data.remove(entry.getKey());
            }
            values.put((String)entry.getKey(), (String)result.getValue());
        }
        this.m_beanValuesMap.put(obj, values);
    }

    public List<String> getParamNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.m_fields) {
            if (this.m_data.containsKey(key)) continue;
            list.add(this.m_shortKeys.get(key));
        }
        return list;
    }

    public String getParams(Object obj) {
        Map<String, String> map = this.m_beanValuesMap.get(obj);
        boolean addComma = false;
        StringBuilder buf = new StringBuilder();
        if (map != null) {
            for (String key : this.m_fields) {
                if (this.m_data.containsKey(key)) continue;
                String val = map.get(key);
                if (addComma) {
                    buf.append(",").append(val);
                } else {
                    buf.append(val);
                }
                addComma = true;
            }
        } else {
            return null;
        }
        return buf.toString();
    }

    public String toJson() {
        StringBuilder buf = new StringBuilder();
        boolean addComma = false;
        buf.append("{");
        for (Map.Entry entry : this.m_bdata.m_readableProps.entrySet()) {
            String key = (String)entry.getKey();
            String val = this.m_data.containsKey(key) ? this.m_data.get(key) : this.m_shortKeys.get(key);
            if (addComma) {
                buf.append(",");
            }
            buf.append(key).append(":").append(val);
            addComma = true;
        }
        buf.append("}");
        return buf.toString();
    }

    public String getScope() {
        return this.m_scope_prefix;
    }

    public Map<Object, Map<String, String>> getBeanValuesMap() {
        return this.m_beanValuesMap;
    }

    public Map<String, String> getShortKeys() {
        return this.m_shortKeys;
    }

    public Class getOptClass() {
        return this.m_class;
    }
}

