/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.cache.meta;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;

public class GrouppedBaseInfo {
    private String m_nonSecureAggResId;
    private String m_secureAggResId;
    private Map<String, String> m_aggChecksum = new HashMap<String, String>();
    private Map<String, String> m_permutationSecureAggrId = new LinkedHashMap<String, String>();
    private Map<String, String> m_permutationNonSecureAggrId = new LinkedHashMap<String, String>();
    private final String m_index;
    private String m_relativePath;
    private String m_optimizedPath;
    private String m_viewId;
    private GrouppedBaseInfo m_parentGroup;
    private boolean m_languageSpecific;

    GrouppedBaseInfo(String index) {
        this.m_index = index;
    }

    public void addAggChecksum(String aggResId, String checksum) {
        this.m_aggChecksum.put(aggResId, checksum);
    }

    public String getAggChecksum(String aggResId) {
        return this.m_aggChecksum.get(aggResId);
    }

    public Map<String, String> getAggChecksums() {
        return this.m_aggChecksum;
    }

    public String getNonSecureAggResId() {
        return this.m_nonSecureAggResId;
    }

    public String getSecureAggResId() {
        return this.getSecureAggResId(true);
    }

    public String getSecureAggResId(boolean fallback) {
        if (this.m_secureAggResId == null && fallback) {
            return this.getNonSecureAggResId();
        }
        return this.m_secureAggResId;
    }

    public void setSecureAggResId(String aggResId) {
        this.m_secureAggResId = aggResId;
    }

    public void setNonSecureAggResId(String aggResId) {
        this.m_nonSecureAggResId = aggResId;
    }

    public Map<String, String> getAllSecureAggResId() {
        return this.m_permutationSecureAggrId;
    }

    public boolean isLanguageSpecific() {
        return this.m_languageSpecific;
    }

    public String getSecureAggResId(Permutation permutation) {
        String aggResId = this.m_permutationSecureAggrId.get(permutation.toExternal());
        if (aggResId != null) {
            return aggResId;
        }
        aggResId = this.m_permutationNonSecureAggrId.get(permutation.toExternal());
        if (aggResId != null) {
            return aggResId;
        }
        if (permutation.isExtended()) {
            aggResId = this.getSecureAggResId(permutation.getParent());
        }
        if (aggResId == null) {
            aggResId = this.getSecureAggResId();
        }
        return aggResId;
    }

    public Map<String, String> getAllNonSecureAggResId() {
        return this.m_permutationNonSecureAggrId;
    }

    public String getNonSecureAggResId(Permutation permutation) {
        String aggResId = this.m_permutationNonSecureAggrId.get(permutation.toExternal());
        if (aggResId != null) {
            return aggResId;
        }
        if (permutation.isExtended()) {
            aggResId = this.getNonSecureAggResId(permutation.getParent());
        }
        if (aggResId == null) {
            aggResId = this.getNonSecureAggResId();
        }
        return aggResId;
    }

    public boolean addSecureAggResid(String key, String aggId) {
        if (Permutation.isLanguageSpecific((String)key)) {
            this.m_languageSpecific = true;
        }
        if (this.containsSecureAggResId(key, aggId)) {
            return false;
        }
        if (this.getSecureAggResId() == null) {
            this.setSecureAggResId(aggId);
            return true;
        }
        String oldValue = this.m_permutationSecureAggrId.get(key);
        if (oldValue == null || !aggId.equals(oldValue)) {
            this.m_permutationSecureAggrId.put(key, aggId);
            return true;
        }
        return false;
    }

    public boolean addSecureAggResid(Permutation permutation, String aggId) {
        return this.addSecureAggResid(permutation.toExternal(), aggId);
    }

    public void registerPermutation(Permutation permutation) {
        if (permutation.isLanguageSpecific()) {
            this.m_languageSpecific = true;
        }
    }

    public boolean addNonSecureAggResid(String key, String aggId) {
        if (Permutation.isLanguageSpecific((String)key)) {
            this.m_languageSpecific = true;
        }
        if (this.getNonSecureAggResId() == null) {
            this.setNonSecureAggResId(aggId);
            return true;
        }
        if (aggId.equals(this.getNonSecureAggResId())) {
            return false;
        }
        String oldValue = this.m_permutationNonSecureAggrId.get(key);
        if (oldValue == null || !aggId.equals(oldValue)) {
            this.m_permutationNonSecureAggrId.put(key, aggId);
            return true;
        }
        return false;
    }

    public boolean containsNonSecureAggResId(String key, String aggId) {
        return aggId.equals(this.getNonSecureAggResId()) || aggId.equals(this.m_permutationNonSecureAggrId.get(key));
    }

    public boolean containsSecureAggResId(String key, String aggId) {
        return aggId.equals(this.m_permutationSecureAggrId.get(key)) || aggId.equals(this.getSecureAggResId()) || this.containsNonSecureAggResId(key, aggId);
    }

    public void addNonSecureAggResid(Permutation permutation, String aggId) {
        this.addNonSecureAggResid(permutation.toExternal(), aggId);
    }

    public String getIndex() {
        return this.m_index;
    }

    public String getRelativePath() {
        return this.m_relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.m_relativePath = relativePath;
    }

    public String getOptimizedPath() {
        return this.m_optimizedPath;
    }

    public void setOptimizedPath(String optimizedPath) {
        this.m_optimizedPath = optimizedPath;
    }

    public GrouppedBaseInfo getParentGroup() {
        return this.m_parentGroup;
    }

    public void setParentGroup(GrouppedBaseInfo parentGroup) {
        this.m_parentGroup = parentGroup;
    }

    public String getViewId() {
        return this.m_viewId;
    }

    public void setViewId(String viewId) {
        this.m_viewId = viewId;
    }
}

