/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdi.agent.host;

import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jsdi.FunctionSource;
import org.eclipse.vjet.dsf.jsdi.IDebuggerControl;
import org.eclipse.vjet.dsf.jsdi.IGuiCallback;
import org.eclipse.vjet.dsf.jsdi.ISourceInfo;
import org.eclipse.vjet.dsf.jsdi.IVariable;
import org.eclipse.vjet.dsf.jsdi.StackFrameInfo;
import org.eclipse.vjet.dsf.jsdi.agent.remote.IDebuggerClient;

public class DebuggerConnector
implements IGuiCallback,
IDebuggerControl {
    private IDebuggerControl m_debuggerControl;
    private IDebuggerClient m_debuggerClient;
    private String m_host;
    private List<Remote> m_bindedRemotes = new ArrayList<Remote>();

    public DebuggerConnector(IDebuggerControl debuggerControl, String host) {
        this.m_host = host;
        try {
            this.connect(debuggerControl);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void compileScript(String url, String text) throws RemoteException {
        this.m_debuggerControl.compileScript(url, text);
    }

    @Override
    public void contextSwitch(int frameIndex) throws RemoteException {
        this.m_debuggerControl.contextSwitch(frameIndex);
    }

    @Override
    public String eval(String expr) throws RemoteException {
        return this.m_debuggerControl.eval(expr);
    }

    @Override
    public void evalScript(String url, String text) throws RemoteException {
        this.m_debuggerControl.evalScript(url, text);
    }

    @Override
    public String[] functionNames() throws RemoteException {
        return this.m_debuggerControl.functionNames();
    }

    @Override
    public FunctionSource functionSourceByName(String functionName) throws RemoteException {
        return this.m_debuggerControl.functionSourceByName(functionName);
    }

    @Override
    public int getFrameCount() throws RemoteException {
        return this.m_debuggerControl.getFrameCount();
    }

    @Override
    public StackFrameInfo getFrameInfo(int frameIndex) throws RemoteException {
        return this.m_debuggerControl.getFrameInfo(frameIndex);
    }

    @Override
    public String getObjectValueAsString(long id) throws RemoteException {
        return this.m_debuggerControl.getObjectValueAsString(id);
    }

    @Override
    public boolean isBreakOnEnter() throws RemoteException {
        return this.m_debuggerControl.isBreakOnEnter();
    }

    @Override
    public boolean isBreakOnExceptions() throws RemoteException {
        return this.m_debuggerControl.isBreakOnExceptions();
    }

    @Override
    public boolean isBreakOnReturn() throws RemoteException {
        return this.m_debuggerControl.isBreakOnReturn();
    }

    @Override
    public IVariable[] loadMembers(long id) throws RemoteException {
        return this.m_debuggerControl.loadMembers(id);
    }

    @Override
    public void setBreak() throws RemoteException {
        this.m_debuggerControl.setBreak();
    }

    @Override
    public void setBreakOnEnter(boolean breakOnEnter) throws RemoteException {
        this.m_debuggerControl.setBreakOnEnter(breakOnEnter);
    }

    @Override
    public void setBreakOnExceptions(boolean breakOnExceptions) throws RemoteException {
        this.m_debuggerControl.setBreakOnExceptions(breakOnExceptions);
    }

    @Override
    public void setBreakOnReturn(boolean breakOnReturn) throws RemoteException {
        this.m_debuggerControl.setBreakOnReturn(breakOnReturn);
    }

    @Override
    public void setGuiCallback(IGuiCallback callback) throws RemoteException {
    }

    @Override
    public void setReturnValue(int returnValue) throws RemoteException {
        this.m_debuggerControl.setReturnValue(returnValue);
    }

    @Override
    public boolean shouldBreak() throws RemoteException {
        return this.m_debuggerControl.shouldBreak();
    }

    @Override
    public ISourceInfo getSourceInfo(String url) throws RemoteException {
        ISourceInfo info = this.m_debuggerControl.getSourceInfo(url);
        this.m_bindedRemotes.add(info);
        return (ISourceInfo)UnicastRemoteObject.exportObject((Remote)info, 0);
    }

    @Override
    public boolean stringIsCompilableUnit(String str) throws RemoteException {
        return this.m_debuggerControl.stringIsCompilableUnit(str);
    }

    @Override
    public void connect(IDebuggerControl debuggerControl) throws RemoteException {
        this.m_debuggerControl = debuggerControl;
        debuggerControl.setGuiCallback(this);
        IDebuggerControl remote = (IDebuggerControl)UnicastRemoteObject.exportObject((Remote)this, 0);
        Registry registry = LocateRegistry.getRegistry(this.m_host);
        try {
            this.m_debuggerClient = (IDebuggerClient)registry.lookup("DebuggerClient");
        }
        catch (NotBoundException e) {
            throw new RuntimeException(e);
        }
        this.m_debuggerClient.connect(remote);
    }

    @Override
    public void detach(boolean shutdown) throws RemoteException {
        UnicastRemoteObject.unexportObject(this, true);
        for (Remote obj : this.m_bindedRemotes) {
            UnicastRemoteObject.unexportObject(obj, true);
        }
        this.m_debuggerClient.detach(shutdown);
    }

    @Override
    public void dispatchNextGuiEvent() throws InterruptedException, RemoteException {
        this.m_debuggerClient.dispatchNextGuiEvent();
    }

    @Override
    public void enterInterrupt(StackFrameInfo frameInfo, String threadTitle, String alertMessage) throws RemoteException {
        this.m_debuggerClient.enterInterrupt(frameInfo, threadTitle, alertMessage);
    }

    @Override
    public int[] getBreakPoints(String url) throws RemoteException {
        return this.m_debuggerClient.getBreakPoints(url);
    }

    @Override
    public boolean isGuiEventThread() throws RemoteException {
        return this.m_debuggerClient.isGuiEventThread();
    }

    @Override
    public void updateSourceText(ISourceInfo sourceInfo) throws RemoteException {
        this.m_bindedRemotes.add(sourceInfo);
        this.m_debuggerClient.updateSourceText((ISourceInfo)UnicastRemoteObject.exportObject((Remote)sourceInfo, 0));
    }
}

