/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.js.dbgp.BreakPoint;

public class BreakPointManager {
    public static final String SCRIPT_STR = "#Script#";
    private Map<String, Map<Integer, BreakPoint>> m_fileMap = new HashMap<String, Map<Integer, BreakPoint>>();
    private Map<String, BreakPoint> m_ids = new HashMap<String, BreakPoint>();
    private Map<String, BreakPoint> m_returnNames = new HashMap<String, BreakPoint>();
    private Map<String, List<BreakPoint>> m_watchpoints = new HashMap<String, List<BreakPoint>>();
    private Map<String, BreakPoint> m_callNames = new HashMap<String, BreakPoint>();

    public void removeBreakPoint(String id) {
        BreakPoint object = this.m_ids.get(id);
        if (object != null) {
            this.removeBreakPoint(object);
        }
    }

    public final void addBreakPoint(BreakPoint point) {
        Object object;
        if (point.m_isReturn) {
            this.m_returnNames.put(point.m_method, point);
        }
        if (point.m_isCall) {
            this.m_callNames.put(point.m_method, point);
        }
        if (point.m_isWatch) {
            object = this.m_watchpoints.get(point.m_expression);
            if (object == null) {
                object = new ArrayList<BreakPoint>();
                this.m_watchpoints.put(point.m_expression, (List<BreakPoint>)object);
            }
            object.add(point);
        }
        if ((object = this.m_fileMap.get(point.m_file)) == null) {
            object = new HashMap();
            this.m_fileMap.put(point.m_file, (Map<Integer, BreakPoint>)object);
        }
        object.put(point.m_line, point);
        this.m_ids.put("p" + point.m_id, point);
    }

    public void removeBreakPoint(BreakPoint point) {
        Map<Integer, BreakPoint> object;
        if (point.m_isReturn) {
            this.m_returnNames.remove(point.m_method);
        }
        if (point.m_isCall) {
            this.m_callNames.remove(point.m_method);
        }
        if (point.m_isWatch) {
            this.m_watchpoints.remove(point.m_expression);
        }
        if ((object = this.m_fileMap.get(point.m_file)) == null) {
            return;
        }
        object.remove(point.m_line);
        this.m_ids.remove("p" + point.m_id);
    }

    public BreakPoint hit(String sourcePath, int lineNumber) {
        Map<Integer, BreakPoint> q = this.m_fileMap.get(sourcePath);
        if (q == null) {
            return null;
        }
        Integer lnNumber = lineNumber;
        BreakPoint point = q.get(lnNumber);
        if (point == null) {
            return null;
        }
        ++point.m_currentHitCount;
        if (point.m_hitValue > 0) {
            if (point.m_hitCondition == 1 && point.m_hitValue >= point.m_currentHitCount) {
                return null;
            }
            if (point.m_hitCondition == 2 && point.m_hitValue != point.m_currentHitCount) {
                return null;
            }
            if (point.m_hitCondition == 3 && point.m_currentHitCount % point.m_hitValue != 0) {
                return null;
            }
        }
        if (point.m_isTemporary) {
            q.remove(lnNumber);
        }
        return point;
    }

    public void updateBreakpoint(String id, String newState, String newLine, String hitValue, String hitCondition, String condexpression) {
        BreakPoint p = this.m_ids.get(id);
        if (p != null) {
            if (newState != null) {
                if ((newState = newState.trim()).equals("enabled")) {
                    p.setEnabled(true);
                } else if (newState.equals("disabled")) {
                    p.setEnabled(false);
                }
            }
            if (newLine != null) {
                Integer nl;
                Map<Integer, BreakPoint> map = this.m_fileMap.get(p.m_file);
                BreakPoint po = map.get(nl = Integer.valueOf(p.m_line));
                if (po != p) {
                    throw new RuntimeException("Error: mismatch break point at line " + nl);
                }
                map.remove(nl);
                map.put(Integer.valueOf(newLine), p);
            }
            if (hitValue != null) {
                p.m_hitValue = Integer.parseInt(hitValue);
            }
            if (hitCondition != null) {
                p.setHitCondition(hitCondition);
            }
            if (!p.m_isWatch) {
                p.m_expression = condexpression;
            } else {
                p.m_isModification = condexpression.charAt(condexpression.length() - 1) == '1';
                p.m_isAccess = condexpression.charAt(condexpression.length() - 2) == '1';
                p.m_expression = condexpression.substring(0, condexpression.length() - 2);
            }
        }
    }

    public BreakPoint hitEnter(String sn) {
        return this.m_callNames.get(sn);
    }

    public BreakPoint hitExit(String sn) {
        return this.m_returnNames.get(sn);
    }

    public List<BreakPoint> getWatchPoints(String property) {
        return this.m_watchpoints.get(property);
    }

    public BreakPoint getBreakpoint(String id) {
        return this.m_ids.get(id);
    }

    public void removeBreakPoints() {
        this.m_fileMap.clear();
        this.m_ids.clear();
        this.m_returnNames.clear();
        this.m_watchpoints.clear();
        this.m_callNames.clear();
    }
}

