/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.AHtmlCollection;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlInput;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlSelect;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlTextArea;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.dap.util.DapDomHelper;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DForm;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.jsnative.HtmlCollection;
import org.eclipse.vjet.dsf.jsnative.HtmlForm;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.mozilla.mod.javascript.Scriptable;
import org.w3c.dom.Node;

public class AHtmlForm
extends AHtmlElement
implements HtmlForm {
    private static final long serialVersionUID = 1L;
    private static final String SUBMIT_JS_METHOD = "submit()";
    private static final String RESET_JS_METHOD = "reset()";
    private AHtmlCollection m_elements;

    protected AHtmlForm(AHtmlDocument doc, DForm form) {
        super(doc, (BaseHtmlElement)form);
        this.populateScriptable(AHtmlForm.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    public String getAcceptCharset() {
        return this.getDForm().getHtmlAcceptCharset();
    }

    public String getAction() {
        return this.getDForm().getHtmlAction();
    }

    public HtmlCollection getElements() {
        if (this.m_elements == null) {
            this.m_elements = new AHtmlCollection(this, 8);
        }
        return this.m_elements;
    }

    public String getEnctype() {
        return this.getDForm().getHtmlEnctype();
    }

    public String getMethod() {
        return this.getDForm().getHtmlMethod();
    }

    public String getName() {
        return this.getDForm().getHtmlName();
    }

    public String getTarget() {
        return this.getDForm().getHtmlTarget();
    }

    public void reset() {
        IBrowserBinding browserBinding;
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc != null && (browserBinding = doc.getBrowserBinding()) != null) {
            browserBinding.executeDomMethod((BaseHtmlElement)this.getDForm(), RESET_JS_METHOD);
        }
    }

    public void setAcceptCharset(String acceptCharset) {
        this.getDForm().setHtmlAcceptCharset(acceptCharset);
        this.onAttrChange(EHtmlAttr.accept_charset, acceptCharset);
    }

    public void setAction(String binding) {
        this.getDForm().setHtmlAction(binding);
        this.onAttrChange(EHtmlAttr.action, binding);
    }

    public void setEnctype(String enctype) {
        this.getDForm().setHtmlEnctype(enctype);
        this.onAttrChange(EHtmlAttr.enctype, enctype);
    }

    public void setMethod(String method) {
        this.getDForm().setHtmlMethod(method);
        this.onAttrChange(EHtmlAttr.method, method);
    }

    public void setName(String name) {
        this.getDForm().setHtmlName(name);
        this.onAttrChange(EHtmlAttr.name, name);
    }

    public void setTarget(String target) {
        this.getDForm().setHtmlTarget(target);
        this.onAttrChange(EHtmlAttr.target, target);
    }

    public void submit() {
        IBrowserBinding browserBinding;
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc != null && (browserBinding = doc.getBrowserBinding()) != null) {
            browserBinding.executeDomMethod((BaseHtmlElement)this.getDForm(), SUBMIT_JS_METHOD);
        }
    }

    public int getLength() {
        return this.getDForm().getHtmlLength();
    }

    public Object get(int index, Scriptable start) {
        Object obj = null;
        obj = this.findElemObject(index);
        if (obj != null) {
            return obj;
        }
        obj = super.get(index, start);
        return obj;
    }

    private Object findElemObject(int index) {
        return this.getElements().item(index);
    }

    public Object get(String name, Scriptable start) {
        Object obj = null;
        obj = this.findElemObject(name);
        if (obj != null) {
            return obj;
        }
        obj = super.get(name, start);
        return obj;
    }

    private Object findElemObject(String name) {
        HtmlCollection elements = this.getElements();
        int i = 0;
        while (i < elements.getLength()) {
            AHtmlElement elem = (AHtmlElement)elements.item(i);
            if (elem instanceof AHtmlInput && ((AHtmlInput)elem).getName().equals(name)) {
                return elem;
            }
            if (elem instanceof AHtmlSelect && ((AHtmlSelect)elem).getName().equals(name)) {
                return elem;
            }
            if (elem instanceof AHtmlTextArea && ((AHtmlTextArea)elem).getName().equals(name)) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    private DForm getDForm() {
        return (DForm)this.getDNode();
    }

    public String getReferenceAsJs() {
        return DapDomHelper.getPath((Node)this.getDForm());
    }

    public Object getOnblur() {
        return this.getOnBlur();
    }

    public Object getOnfocus() {
        return this.getOnFocus();
    }

    public void setOnblur(Object functionRef) {
        this.setOnBlur(functionRef);
    }

    public void setOnfocus(Object functionRef) {
        this.setOnFocus(functionRef);
    }

    public Object getOnkeydown() {
        return this.getOnKeyDown();
    }

    public void setOnkeydown(Object functionRef) {
        this.setOnKeyDown(functionRef);
    }

    public Object getOnkeypress() {
        return this.getOnKeyPress();
    }

    public void setOnkeypress(Object functionRef) {
        this.setOnKeyPress(functionRef);
    }

    public Object getOnkeyup() {
        return this.getOnKeyUp();
    }

    public void setOnkeyup(Object functionRef) {
        this.setOnKeyUp(functionRef);
    }

    public Object getOnresize() {
        return this.getOnResize();
    }

    public void setOnresize(Object functionRef) {
        this.setOnResize(functionRef);
    }

    public Object getOnreset() {
        return this.getOnReset();
    }

    public void setOnreset(Object functionRef) {
        this.setOnReset(functionRef);
    }

    public Object getOnsubmit() {
        return this.getOnSubmit();
    }

    public void setOnsubmit(Object functionRef) {
        this.setOnSubmit(functionRef);
    }

    public Object getOnclick() {
        return this.getOnClick();
    }

    public void setOnclick(Object functionRef) {
        this.setOnClick(functionRef);
    }

    public Object getOndblclick() {
        return this.getOnDblClick();
    }

    public void setOndblclick(Object functionRef) {
        this.setOnDblClick(functionRef);
    }

    public Object getOnmousedown() {
        return this.getOnMouseDown();
    }

    public void setOnmousedown(Object functionRef) {
        this.setOnMouseDown(functionRef);
    }

    public Object getOnmousemove() {
        return this.getOnMouseMove();
    }

    public void setOnmousemove(Object functionRef) {
        this.setOnMouseMove(functionRef);
    }

    public Object getOnmouseout() {
        return this.getOnMouseOut();
    }

    public void setOnmouseout(Object functionRef) {
        this.setOnMouseOut(functionRef);
    }

    public Object getOnmouseover() {
        return this.getOnMouseOver();
    }

    public void setOnmouseover(Object functionRef) {
        this.setOnMouseOver(functionRef);
    }

    public Object getOnmouseup() {
        return this.getOnMouseUp();
    }

    public void setOnmouseup(Object functionRef) {
        this.setOnMouseUp(functionRef);
    }
}

