/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.client;

import org.eclipse.vjet.dsf.active.client.ActiveObject;
import org.eclipse.vjet.dsf.active.dom.html.AElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.html.dom.ECssAttr;
import org.eclipse.vjet.dsf.jsnative.TextRectangle;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;

public class ATextRectangle
extends ActiveObject
implements TextRectangle {
    private static final long serialVersionUID = 8944913938454122242L;
    private AHtmlDocument m_doc;
    private AElement m_elem;
    private IBrowserBinding m_browserBinding;
    private static final String GET_BOUNDING_CLIENT_RECT = "getBoundingClientRect()";

    public ATextRectangle(AHtmlDocument doc, AElement elem, IBrowserBinding browserBinding) {
        this.m_doc = doc;
        this.m_elem = elem;
        this.m_browserBinding = browserBinding;
        this.populateScriptable(ATextRectangle.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    public float getBottom() {
        return this.getFloatBindingValue(ECssAttr.bottom);
    }

    public float getLeft() {
        return this.getFloatBindingValue(ECssAttr.left);
    }

    public float getRight() {
        return this.getFloatBindingValue(ECssAttr.right);
    }

    public float getTop() {
        return this.getFloatBindingValue(ECssAttr.top);
    }

    private float getFloatBindingValue(ECssAttr attr) {
        if (this.m_browserBinding != null && this.m_doc != null && this.m_elem != null) {
            String code = AHtmlHelper.getElementPath((AHtmlElement)this.m_elem);
            code = String.valueOf(code) + ".getBoundingClientRect().";
            String value = this.m_browserBinding.executeJs(code = String.valueOf(code) + attr.cssName());
            if (value == null || value.length() == 0) {
                return 0.0f;
            }
            try {
                return Float.parseFloat(value);
            }
            catch (Exception exception) {
                return 0.0f;
            }
        }
        return 0.0f;
    }
}

