/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.Flags;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.ScriptElementImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.vjet.eclipse.core.IImportDeclaration;
import org.eclipse.vjet.eclipse.internal.core.util.Util;
import org.eclipse.vjet.eclipse.ui.VjetUIImages;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;
import org.eclipse.vjet.eclipse.ui.VjetUIUtils;
import org.eclipse.vjet.eclipse.ui.VjoElementImageDescriptor;

public class VjoElementImageProvider
extends ScriptElementImageProvider
implements ILabelProvider {
    private static boolean confirmAbstract(IMember member) {
        return false;
    }

    public static ImageDescriptor getFieldImageDescriptor(int flags) {
        if ((flags & 0x4000) != 0) {
            return VjetUIImages.DESC_FIELD_GLOBAL;
        }
        ImageDescriptor descriptor = Flags.isPrivate((int)flags) ? DLTKUIPlugin.getImageDescriptor((String)"icons/full/obj16/field_private_obj.gif") : (Flags.isPublic((int)flags) ? DLTKUIPlugin.getImageDescriptor((String)"icons/full/obj16/field_public_obj.gif") : (Flags.isProtected((int)flags) ? DLTKUIPlugin.getImageDescriptor((String)"icons/full/obj16/field_protected_obj.gif") : DLTKPluginImages.DESC_FIELD_DEFAULT));
        return descriptor;
    }

    private static boolean isEnumConstant(IMember member, int modifiers) {
        return false;
    }

    private static boolean isInterfaceOrAnnotationField(IMember member) {
        return false;
    }

    private static boolean isInterfaceOrAnnotationFieldOrType(IMember member) {
        return false;
    }

    private static boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    private int computeVjoAdornmentFlags(IModelElement element, int renderFlags) {
        int flags = 0;
        if (VjoElementImageProvider.showOverlayIcons(renderFlags) && element instanceof IMember) {
            try {
                int modifiers;
                IMember member = (IMember)element;
                if (element.getElementType() == 9 && ((IMethod)element).isConstructor()) {
                    flags |= 0x200;
                }
                if (((modifiers = member.getFlags()) & 0x400) != 0) {
                    flags |= 1;
                }
                if ((modifiers & 0x10) != 0 || VjoElementImageProvider.isInterfaceOrAnnotationField(member) || VjoElementImageProvider.isEnumConstant(member, modifiers)) {
                    flags |= 2;
                }
                if ((modifiers & 0x100) != 0 || VjoElementImageProvider.isInterfaceOrAnnotationFieldOrType(member) || VjoElementImageProvider.isEnumConstant(member, modifiers)) {
                    flags |= 8;
                }
                if ((modifiers & 0x4000) != 0) {
                    flags |= 0x1000;
                }
                if ((modifiers & 0x80) != 0 && member.getElementType() == 8 && member.getParent().getElementType() == 8) {
                    flags |= 0x10000;
                }
                if (member.getElementType() == 7 && VjetUIUtils.isMixin((IType)member)) {
                    flags |= 0x800;
                }
            }
            catch (ModelException modelException) {}
        }
        return flags;
    }

    public ImageDescriptor getBaseImageDescriptor(IModelElement element, int renderFlags) {
        if (element instanceof IModelElement) {
            int elementType = element.getElementType();
            try {
                switch (elementType) {
                    case 12: {
                        return DLTKPluginImages.DESC_OBJS_IMPCONT;
                    }
                    case 13: {
                        if (((IImportDeclaration)element).isLibrary()) {
                            ImageDescriptor descriptor = VjetUIPlugin.getImageDescriptor("icons/full/obj16/imp_lib.gif");
                            return descriptor;
                        }
                        return DLTKPluginImages.DESC_OBJS_IMPDECL;
                    }
                    case 11: {
                        return DLTKPluginImages.DESC_METHOD_PRIVATE;
                    }
                    case 8: {
                        int flags = ((IField)element).getFlags();
                        return VjoElementImageProvider.getFieldImageDescriptor(flags);
                    }
                    case 7: {
                        IType type = (IType)element;
                        return VjoElementImageProvider.getTypeImageDescriptor(type.getFlags(), VjoElementImageProvider.useLightIcons(renderFlags));
                    }
                    case 9: {
                        int flags = ((IMethod)element).getFlags();
                        return VjoElementImageProvider.getMethodImageDescriptor(flags);
                    }
                    case 3: {
                        IProjectFragment root = (IProjectFragment)element;
                        if (root.isExternal()) {
                            if (root.isArchive() || Util.isNativeCacheDir((IPath)root.getPath())) {
                                return DLTKPluginImages.DESC_OBJS_JAR_WSRC;
                            }
                            return DLTKPluginImages.DESC_OBJS_PACKFRAG_ROOT;
                        }
                        if (root.isArchive()) {
                            return DLTKPluginImages.DESC_OBJS_JAR_WSRC;
                        }
                        return DLTKPluginImages.DESC_OBJS_PACKFRAG_ROOT;
                    }
                }
            }
            catch (ModelException e) {
                if (e.isDoesNotExist()) {
                    return DLTKPluginImages.DESC_OBJS_UNKNOWN;
                }
                DLTKUIPlugin.log((Throwable)e);
                return DLTKPluginImages.DESC_OBJS_GHOST;
            }
        }
        return super.getBaseImageDescriptor(element, renderFlags);
    }

    public static ImageDescriptor getMethodImageDescriptor(int flags) {
        if ((flags & 0x4000) != 0) {
            return VjetUIImages.DESC_METHOD_GLOBAL;
        }
        return ScriptElementImageProvider.getMethodImageDescriptor((int)flags);
    }

    public ImageDescriptor getScriptImageDescriptor(IModelElement element, int flags) {
        Point size = VjoElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        ImageDescriptor descr = this.getBaseImageDescriptor(element, flags);
        if (descr != null) {
            int adornmentFlags = this.computeVjoAdornmentFlags(element, flags);
            return new VjoElementImageDescriptor(descr, adornmentFlags, size);
        }
        return null;
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        Point size = VjoElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new VjoElementImageDescriptor(descriptor, 0, size);
    }

    public static ImageDescriptor getTypeImageDescriptor(int flags, boolean useLightIcons) {
        if ((flags & 0x200) != 0) {
            if (useLightIcons) {
                return DLTKUIPlugin.getImageDescriptor((String)"icons/full/obj16/intf_obj.gif");
            }
            return VjoElementImageProvider.getInterfaceImageDescriptor(flags);
        }
        if ((flags & 0x4000) != 0) {
            if (useLightIcons) {
                return DLTKUIPlugin.getImageDescriptor((String)"icons/full/obj16/enum_obj.gif");
            }
            return VjoElementImageProvider.getEnumImageDescriptor(flags);
        }
        if ((flags & 0x8000) != 0) {
            if (useLightIcons) {
                return DLTKUIPlugin.getImageDescriptor((String)"icons/full/obj16/module_obj.gif");
            }
            return VjoElementImageProvider.getModuleImageDescriptor(flags);
        }
        if (useLightIcons) {
            return DLTKPluginImages.DESC_OBJS_CLASSALT;
        }
        return VjoElementImageProvider.getClassImageDescriptor(flags);
    }

    private static ImageDescriptor getClassImageDescriptor(int flags) {
        if ((flags & 0x1000) != 0) {
            return DLTKPluginImages.DESC_OBJS_NAMESPACE;
        }
        if ((flags & 0x800) != 0) {
            return DLTKPluginImages.DESC_OBJS_MODULE;
        }
        return DLTKPluginImages.DESC_OBJS_CLASS;
    }

    private static ImageDescriptor getInterfaceImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return DLTKUIPlugin.getImageDescriptor((String)"icons/full/obj16/int_obj.gif");
        }
        return DLTKUIPlugin.getImageDescriptor((String)"icons/full/obj16/int_default_obj.gif");
    }

    private static ImageDescriptor getEnumImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return DLTKUIPlugin.getImageDescriptor((String)"icons/full/obj16/enum_obj.gif");
        }
        return DLTKUIPlugin.getImageDescriptor((String)"icons/full/obj16/enum_default_obj.gif");
    }

    private static ImageDescriptor getModuleImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return DLTKUIPlugin.getImageDescriptor((String)"icons/full/obj16/module_obj.gif");
        }
        return VjetUIPlugin.getImageDescriptor("icons/full/obj16/module_default_obj.gif");
    }

    private static boolean useLightIcons(int flags) {
        return (flags & 4) != 0;
    }

    protected ILabelProvider getContributedLabelProvider(IModelElement element) {
        return null;
    }

    public Image getImage(Object element) {
        int flags = 0;
        if (element instanceof IMember) {
            try {
                flags = ((IMember)element).getFlags();
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
        }
        return this.getImageLabel(element, flags);
    }

    public String getText(Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

