/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class VjoElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int ABSTRACT = 1;
    public static final int CONSTRUCTOR = 512;
    public static final int DEPRECATED = 1024;
    public static final int ERROR = 64;
    public static final int FINAL = 2;
    public static final int IMPLEMENTS = 256;
    public static final int OVERRIDES = 128;
    public static final int RUNNABLE = 16;
    public static final int STATIC = 8;
    public static final int SYNCHRONIZED = 4;
    public static final int WARNING = 32;
    public static final int MIXIN = 2048;
    public static final int GLOBAL = 4096;
    public static final int OPTION_PRO = 65536;
    private ImageDescriptor m_baseImage;
    private int m_flags;
    private Point m_size;

    public VjoElementImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        this.m_baseImage = baseImage;
        Assert.isNotNull((Object)this.m_baseImage);
        this.m_flags = flags;
        Assert.isTrue((this.m_flags >= 0 ? 1 : 0) != 0);
        this.m_size = size;
        Assert.isNotNull((Object)this.m_size);
    }

    private void drawBottomLeft() {
        ImageData data;
        Point size = this.getSize();
        int x = 0;
        if ((this.m_flags & 0x40) != 0) {
            data = this.getImageData(DLTKPluginImages.DESC_OVR_ERROR);
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
        if ((this.m_flags & 0x20) != 0) {
            data = this.getImageData(DLTKPluginImages.DESC_OVR_WARNING);
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
    }

    private void drawBottomRight() {
        ImageData data;
        Point size = this.getSize();
        int x = size.x;
        int flags = this.m_flags;
        int syncAndOver = 132;
        int syncAndImpl = 260;
        if ((flags & syncAndOver) == syncAndOver) {
            data = this.getImageData(this.getDescriptor("icons/full/ovr16/sync_over.gif"));
            this.drawImage(data, x -= data.width, size.y - data.height);
            flags &= ~syncAndOver;
        } else if ((flags & syncAndImpl) == syncAndImpl) {
            data = this.getImageData(this.getDescriptor("icons/full/ovr16/sync_impl.gif"));
            this.drawImage(data, x -= data.width, size.y - data.height);
            flags &= ~syncAndImpl;
        }
        if ((flags & 0x80) != 0) {
            data = this.getImageData(this.getDescriptor("icons/full/ovr16/over_co.gif"));
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
        if ((flags & 0x100) != 0) {
            data = this.getImageData(this.getDescriptor("icons/full/ovr16/implm_co.gif"));
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
        if ((flags & 4) != 0) {
            data = this.getImageData(this.getDescriptor("icons/full/ovr16/synch_co.gif"));
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
        if ((flags & 0x10) != 0) {
            data = this.getImageData(this.getDescriptor("icons/full/ovr16/run_co.gif"));
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.m_baseImage);
        if ((this.m_flags & 0x400) != 0) {
            Point size = this.getSize();
            ImageData data = this.getImageData(this.getDescriptor("icons/full/ovr16/deprecated.gif"));
            this.drawImage(data, 0, size.y - data.height);
        }
        this.drawImage(bg, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private void drawTopRight() {
        ImageData data;
        int x = this.getSize().x;
        if ((this.m_flags & 1) != 0) {
            data = this.getImageData(DLTKPluginImages.DESC_OVR_ABSTRACT);
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.m_flags & 0x200) != 0) {
            data = this.getImageData(this.getDescriptor("icons/full/ovr16/constr_ovr.gif"));
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.m_flags & 2) != 0) {
            data = this.getImageData(this.getDescriptor("icons/full/ovr16/final_co.gif"));
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.m_flags & 8) != 0) {
            data = this.getImageData(this.getDescriptor("icons/full/ovr16/static_co.gif"));
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.m_flags & 0x800) != 0) {
            data = this.getImageData(VjetUIPlugin.getImageDescriptor("icons/full/ovr16/module_co.gif"));
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.m_flags & 0x1000) != 0) {
            data = this.getImageData(DLTKPluginImages.DESC_OVR_FIELD_GLOBAL);
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.m_flags & 0x10000) != 0) {
            data = this.getImageData(DLTKPluginImages.DESC_OVR_FIELD_INDEX);
            this.drawImage(data, x -= data.width, 0);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !VjoElementImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        VjoElementImageDescriptor other = (VjoElementImageDescriptor)((Object)object);
        return this.m_baseImage.equals(other.m_baseImage) && this.m_flags == other.m_flags && this.m_size.equals((Object)other.m_size);
    }

    public int getAdronments() {
        return this.m_flags;
    }

    private ImageDescriptor getDescriptor(String path) {
        return DLTKUIPlugin.getImageDescriptor((String)path);
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            DLTKUIPlugin.logErrorMessage((String)("Image data not available: " + descriptor.toString()));
        }
        return data;
    }

    public Point getImageSize() {
        return new Point(this.m_size.x, this.m_size.y);
    }

    protected Point getSize() {
        return this.m_size;
    }

    public int hashCode() {
        return this.m_baseImage.hashCode() | this.m_flags | this.m_size.hashCode();
    }

    public void setAdornments(int adornments) {
        Assert.isTrue((adornments >= 0 ? 1 : 0) != 0);
        this.m_flags = adornments;
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.m_size = size;
    }
}

