/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.view.typespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

class TypespaceTreeContentProvider
implements ITreeContentProvider {
    private boolean m_hideEmptyBinaryGroup = true;
    private int m_proCount;
    private int m_openLibCount;
    private int m_libCount;
    private int m_totalTypeCount;
    private Comparator<? super IGroup> m_groupComparator = new InnerGroupComparator();

    TypespaceTreeContentProvider() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement.getClass().isArray()) {
            return (Object[])parentElement;
        }
        if (parentElement instanceof TypeSpaceMgr) {
            Object[] objs = TypeSpaceMgr.getInstance().getController().getJstTypeSpaceMgr().getTypeSpace().getGroups().values().toArray();
            ArrayList<IGroup> groups = new ArrayList<IGroup>();
            int i = 0;
            while (i < objs.length) {
                IGroup group;
                Object obj = objs[i];
                if (obj instanceof IGroup && this.ifAddGroup(group = (IGroup)obj)) {
                    groups.add(group);
                    this.m_totalTypeCount += group.getEntities().size();
                }
                ++i;
            }
            Collections.sort(groups, this.m_groupComparator);
            return groups.toArray();
        }
        if (parentElement instanceof IGroup) {
            return ((IGroup)parentElement).getEntities().values().toArray();
        }
        if (parentElement instanceof IJstType) {
            IJstType jstType = (IJstType)parentElement;
            ArrayList children = new ArrayList();
            if (jstType.getEmbededTypes() != null) {
                Collections.addAll(children, jstType.getEmbededTypes().toArray());
            }
            Collections.addAll(children, jstType.getChildren().toArray());
            return children.toArray();
        }
        if (parentElement instanceof BaseJstNode) {
            List children = ((BaseJstNode)parentElement).getChildren();
            return children.toArray(new BaseJstNode[children.size()]);
        }
        return null;
    }

    private boolean ifAddGroup(IGroup group) {
        boolean hasChildren;
        String groupName = group.getName();
        boolean bl = hasChildren = !group.getEntities().isEmpty();
        if (CodeassistUtils.isBinaryPath((String)groupName) || CodeassistUtils.isNativeGroup((String)groupName)) {
            ++this.m_libCount;
            if (hasChildren) {
                ++this.m_openLibCount;
            }
        } else {
            ++this.m_proCount;
        }
        if (!this.m_hideEmptyBinaryGroup) {
            return true;
        }
        boolean bol = !CodeassistUtils.isBinaryPath((String)group.getName()) || hasChildren;
        return bol;
    }

    public Object getParent(Object element) {
        if (element instanceof BaseJstNode) {
            return ((BaseJstNode)element).getParentNode();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        this.clearCount();
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.clearCount();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setHideEmptyBinaryGoupr(boolean hideEmptyBinaryGroup) {
        this.m_hideEmptyBinaryGroup = hideEmptyBinaryGroup;
    }

    public boolean ifHideEmptyBinaryGroup() {
        return this.m_hideEmptyBinaryGroup;
    }

    private int getGroupType(IGroup group) {
        String groupName = group.getName();
        if (CodeassistUtils.isBinaryPath((String)groupName)) {
            return 2;
        }
        if (CodeassistUtils.isNativeGroup((String)groupName)) {
            return 0;
        }
        return 1;
    }

    public int getProCount() {
        return this.m_proCount;
    }

    public int getOpenLibCount() {
        if (!this.m_hideEmptyBinaryGroup) {
            return this.m_libCount;
        }
        return this.m_openLibCount;
    }

    public int getLibCount() {
        return this.m_libCount;
    }

    public int getTotalTypeCount() {
        return this.m_totalTypeCount;
    }

    void clearCount() {
        this.m_proCount = 0;
        this.m_openLibCount = 0;
        this.m_libCount = 0;
        this.m_totalTypeCount = 0;
    }

    private class InnerGroupComparator
    implements Comparator<IGroup> {
        private InnerGroupComparator() {
        }

        @Override
        public int compare(IGroup object1, IGroup object2) {
            int iGroup2;
            int iGroup1 = TypespaceTreeContentProvider.this.getGroupType(object1);
            int result = iGroup1 - (iGroup2 = TypespaceTreeContentProvider.this.getGroupType(object2));
            if (result != 0) {
                return result;
            }
            String name1 = object1.getName();
            String name2 = object2.getName();
            return name1.compareTo(name2);
        }
    }
}

