/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.BuildpathContainerInitializer;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IAccessRule;
import org.eclipse.dltk.mod.core.IBuildpathAttribute;
import org.eclipse.dltk.mod.core.IBuildpathContainer;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.mod.internal.core.BuildpathEntry;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.IInterpreterInstallType;
import org.eclipse.dltk.mod.launching.InterpreterStandin;
import org.eclipse.dltk.mod.launching.LaunchingMessages;
import org.eclipse.dltk.mod.launching.LibraryLocation;
import org.eclipse.dltk.mod.launching.ScriptRuntime;
import org.eclipse.vjet.eclipse.internal.launching.BrowserSdkBuildpathContainer;
import org.eclipse.vjet.eclipse.internal.launching.BuildPathUtils;
import org.eclipse.vjet.vjo.lib.TsLibLoader;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class BrowserContainerInitializer
extends BuildpathContainerInitializer {
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    public void initialize(IPath containerPath, IScriptProject project) throws CoreException {
        int size = containerPath.segmentCount();
        if (size > 0 && containerPath.segment(0).equals("org.eclipse.vjet.eclipse.core.BROWSER_CONTAINER")) {
            String[] defaultLibs = TsLibLoader.getBrowserGroups();
            IInterpreterInstall interp = BrowserContainerInitializer.resolveInterpreter(this.getNatureFromProject(project), this.getEnvironmentFromProject(project), containerPath);
            BrowserSdkBuildpathContainer container = null;
            String[] stringArray = defaultLibs;
            int n = defaultLibs.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                BuildPathUtils.addLinkForGroup(group);
                ++n2;
            }
            container = new BrowserSdkBuildpathContainer(interp, containerPath);
            container.setEntries(this.createEntries());
            DLTKCore.setBuildpathContainer((IPath)containerPath, (IScriptProject[])new IScriptProject[]{project}, (IBuildpathContainer[])new IBuildpathContainer[]{container}, null);
        }
    }

    private List createEntries() {
        TypeSpaceMgr.getInstance();
        String[] defaultLibs = TsLibLoader.getBrowserGroups();
        ArrayList<BuildpathEntry> entries = new ArrayList<BuildpathEntry>(defaultLibs.length);
        HashSet<String> rawEntries = new HashSet<String>(defaultLibs.length);
        int i = 0;
        while (i < defaultLibs.length) {
            String groupName = defaultLibs[i];
            if (!rawEntries.contains(groupName)) {
                IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
                ArrayList excluded = new ArrayList();
                LocalEnvironment.getInstance();
                entries.add(new BuildpathEntry(3, 1, ScriptProject.canonicalizedPath((IPath)BuildPathUtils.createPathForGroup(groupName)), false, BuildpathEntry.INCLUDE_ALL, excluded.toArray(new IPath[excluded.size()]), EMPTY_RULES, false, attributes, false));
                rawEntries.add(groupName);
            }
            ++i;
        }
        return entries;
    }

    public static IInterpreterInstall resolveInterpreter(String natureId, String environment, IPath containerPath) throws CoreException {
        String typeId;
        IInterpreterInstallType installType;
        if (containerPath.segmentCount() > 1 && (installType = ScriptRuntime.getInterpreterInstallType((String)(typeId = BrowserContainerInitializer.getInterpreterTypeId(containerPath)))) != null) {
            String name = BrowserContainerInitializer.getInterpreterName(containerPath);
            return installType.findInterpreterInstallByName(name);
        }
        return ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)new ScriptRuntime.DefaultInterpreterEntry(natureId, environment));
    }

    public static String getInterpreterTypeId(IPath path) {
        return path.segment(1);
    }

    public static String getInterpreterName(IPath path) {
        return path.segment(2).replaceAll("%2F", "/");
    }

    public boolean canUpdateBuildpathContainer(IPath containerPath, IScriptProject project) {
        if (containerPath != null && containerPath.segmentCount() > 0 && ScriptRuntime.INTERPRETER_CONTAINER.equals(containerPath.segment(0))) {
            try {
                return BrowserContainerInitializer.resolveInterpreter(this.getNatureFromProject(project), this.getEnvironmentFromProject(project), containerPath) != null;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return false;
    }

    private String getNatureFromProject(IScriptProject project) {
        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)project);
        if (languageToolkit != null) {
            return languageToolkit.getNatureId();
        }
        return null;
    }

    private String getEnvironmentFromProject(IScriptProject project) {
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)project);
        if (environment != null) {
            return environment.getId();
        }
        return null;
    }

    public void requestBuildpathContainerUpdate(IPath containerPath, IScriptProject project, IBuildpathContainer containerSuggestion) throws CoreException {
        IInterpreterInstall interpreter = BrowserContainerInitializer.resolveInterpreter(this.getNatureFromProject(project), this.getEnvironmentFromProject(project), containerPath);
        if (interpreter == null) {
            Status status = new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 105, MessageFormat.format(LaunchingMessages.InterpreterEnvironmentContainerInitializer_InterpreterEnvironment_referenced_by_classpath_container__0__does_not_exist__1, containerPath.toString()), null);
            throw new CoreException((IStatus)status);
        }
        IBuildpathEntry[] entries = containerSuggestion.getBuildpathEntries(project);
        LibraryLocation[] libs = new LibraryLocation[entries.length];
        int i = 0;
        while (i < entries.length) {
            IPath path;
            IBuildpathEntry entry = entries[i];
            if (entry.getEntryKind() == 1) {
                path = entry.getPath();
                File lib = path.toFile();
                if (!lib.exists()) {
                    Status status = new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 100, MessageFormat.format(LaunchingMessages.InterpreterEnvironmentContainerInitializer_Buildpath_entry__0__does_not_refer_to_an_existing_library__2, entry.getPath().toString()), null);
                    throw new CoreException((IStatus)status);
                }
            } else {
                Status status = new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 100, MessageFormat.format(LaunchingMessages.InterpreterEnvironmentContainerInitializer_Buildpath_entry__0__does_not_refer_to_a_library__3, entry.getPath().toString()), null);
                throw new CoreException((IStatus)status);
            }
            libs[i] = new LibraryLocation(path);
            ++i;
        }
        InterpreterStandin standin = new InterpreterStandin(interpreter);
        standin.setLibraryLocations(libs);
        standin.convertToRealInterpreter();
        ScriptRuntime.saveInterpreterConfiguration();
    }

    public String getDescription(IPath containerPath, IScriptProject project) {
        String tag = null;
        if (containerPath.segmentCount() > 2) {
            tag = BrowserContainerInitializer.getInterpreterName(containerPath);
        }
        if (tag != null) {
            return MessageFormat.format(LaunchingMessages.InterpreterEnvironmentContainer_InterpreterEnvironment_System_Library_1, tag);
        }
        return LaunchingMessages.InterpreterEnvironmentContainerInitializer_Default_System_Library_1;
    }
}

