/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.search.indexing.IndexManager;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.ui.preferences.ImprovedAbstractConfigurationBlock;
import org.eclipse.dltk.mod.ui.preferences.Messages;
import org.eclipse.dltk.mod.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.mod.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.mod.ui.util.SWTFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

final class ScriptCorePreferenceBlock
extends ImprovedAbstractConfigurationBlock {
    final FileCacheEntry[] cacheEntries = ScriptCorePreferenceBlock.getFileCaches();
    private Combo cacheCombo;

    ScriptCorePreferenceBlock(OverlayPreferenceStore store, PreferencePage page) {
        super(store, page);
    }

    private static FileCacheEntry[] getFileCaches() {
        ArrayList<FileCacheEntry> result = new ArrayList<FileCacheEntry>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.mod.core.fileCache");
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String id = element.getAttribute("id");
            String name = element.getAttribute("name");
            if (id != null && name != null) {
                result.add(new FileCacheEntry(id, name));
            }
            ++i;
        }
        return result.toArray(new FileCacheEntry[result.size()]);
    }

    @Override
    public Control createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 1808);
        Group coreGroup = SWTFactory.createGroup(composite, Messages.ScriptCorePreferenceBlock_coreOptions, 2, 1, 768);
        SWTFactory.createLabel((Composite)coreGroup, Messages.ScriptCorePreferenceBlock_fileCaching, 1);
        String[] items = new String[this.cacheEntries.length];
        int i = 0;
        while (i < this.cacheEntries.length) {
            items[i] = this.cacheEntries[i].name;
            ++i;
        }
        this.cacheCombo = SWTFactory.createCombo((Composite)coreGroup, 2056, 0, items);
        Group editorGroup = SWTFactory.createGroup(composite, Messages.ScriptCorePreferenceBlock_editOptions, 1, 1, 768);
        this.bindControl(SWTFactory.createCheckButton((Composite)editorGroup, PreferencesMessages.EditorPreferencePage_evaluateTemporaryProblems), "handleTemporaryProblems");
        this.createReIndex(composite);
        return composite;
    }

    private void initializeCacheField(String cacheId) {
        int i = 0;
        while (i < this.cacheEntries.length) {
            if (cacheId != null && cacheId.equals(this.cacheEntries[i].id)) {
                this.cacheCombo.select(i);
                break;
            }
            ++i;
        }
    }

    private void createReIndex(Composite composite) {
        if (DLTKCore.SHOW_REINDEX) {
            Group g = SWTFactory.createGroup(composite, Messages.ScriptCorePreferenceBlock_debugOptionsOperations, 2, 1, 768);
            Label l = new Label((Composite)g, 8);
            l.setText(Messages.ScriptCorePreferencePage_manualReindex);
            Button reCreateIndex = new Button((Composite)g, 8);
            reCreateIndex.setText(Messages.ScriptCorePreferencePage_reindex);
            reCreateIndex.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    block4: {
                        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
                        indexManager.rebuild();
                        try {
                            PlatformUI.getWorkbench().getProgressService().run(false, true, (IRunnableWithProgress)new ReindexOperation());
                        }
                        catch (InvocationTargetException e3) {
                            if (DLTKCore.DEBUG) {
                                e3.printStackTrace();
                            }
                        }
                        catch (InterruptedException e3) {
                            if (!DLTKCore.DEBUG) break block4;
                            e3.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    @Override
    protected List createOverlayKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "handleTemporaryProblems"));
        return overlayKeys;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initializeCacheField(DLTKCore.getPlugin().getPluginPreferences().getString("org.eclipse.dltk.mod.core.contentCache"));
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        this.initializeCacheField(DLTKCore.getPlugin().getPluginPreferences().getDefaultString("org.eclipse.dltk.mod.core.contentCache"));
    }

    @Override
    protected void initializeFields() {
        super.initializeFields();
    }

    @Override
    public void performOk() {
        Preferences prefs;
        String value;
        super.performOk();
        int cacheIndex = this.cacheCombo.getSelectionIndex();
        if (cacheIndex >= 0 && cacheIndex < this.cacheEntries.length && !(value = this.cacheEntries[cacheIndex].id).equals((prefs = DLTKCore.getDefault().getPluginPreferences()).getString("org.eclipse.dltk.mod.core.contentCache"))) {
            prefs.setValue("org.eclipse.dltk.mod.core.contentCache", value);
        }
        DLTKCore.getDefault().savePluginPreferences();
    }

    private static class FileCacheEntry {
        final String id;
        final String name;

        FileCacheEntry(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    private final class ReindexOperation
    implements IRunnableWithProgress {
        private ReindexOperation() {
        }

        public void run(IProgressMonitor monitor) {
            block2: {
                try {
                    ResourcesPlugin.getWorkspace().build(6, monitor);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
        }
    }
}

