/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.filters;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.ui.filters.IFilterElementNameProvider;
import org.eclipse.dltk.mod.internal.ui.util.StringMatcher;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class NamePatternFilter
extends ViewerFilter {
    private String[] fPatterns;
    private StringMatcher[] fMatchers;

    private StringMatcher[] getMatchers() {
        return this.fMatchers;
    }

    public String[] getPatterns() {
        return this.fPatterns;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        String matchName = null;
        if (element instanceof IModelElement) {
            matchName = viewer instanceof IFilterElementNameProvider ? ((IFilterElementNameProvider)viewer).getElementName((IModelElement)element) : ((IModelElement)element).getElementName();
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IModelElement modelElement = (IModelElement)adaptable.getAdapter(IModelElement.class);
            if (modelElement != null) {
                matchName = viewer instanceof IFilterElementNameProvider ? ((IFilterElementNameProvider)viewer).getElementName(modelElement) : modelElement.getElementName();
            } else {
                IResource resource = (IResource)adaptable.getAdapter(IResource.class);
                if (resource != null) {
                    matchName = resource.getName();
                }
            }
        }
        if (matchName != null) {
            StringMatcher[] testMatchers = this.getMatchers();
            int i = 0;
            while (i < testMatchers.length) {
                if (testMatchers[i].match(matchName)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return true;
    }

    public void setPatterns(String[] newPatterns) {
        this.fPatterns = newPatterns;
        this.fMatchers = new StringMatcher[newPatterns.length];
        int i = 0;
        while (i < newPatterns.length) {
            this.fMatchers[i] = new StringMatcher(newPatterns[i], true, false);
            ++i;
        }
    }
}

