/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IParent;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.ScriptElementImageProvider;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DLTKWorkbenchAdapter
implements IWorkbenchAdapter {
    protected static final Object[] NO_CHILDREN = new Object[0];
    private ScriptElementImageProvider fImageProvider = new ScriptElementImageProvider();

    public Object[] getChildren(Object element) {
        IModelElement je = this.getModelElement(element);
        if (je instanceof IParent) {
            try {
                return ((IParent)je).getChildren();
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
        }
        return NO_CHILDREN;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        IModelElement je = this.getModelElement(element);
        if (je != null) {
            return this.fImageProvider.getScriptImageDescriptor(je, 3);
        }
        return null;
    }

    public String getLabel(Object element) {
        return ScriptElementLabels.getDefault().getTextLabel(this.getModelElement(element), ScriptElementLabels.ALL_DEFAULT);
    }

    public Object getParent(Object element) {
        IModelElement je = this.getModelElement(element);
        return je != null ? je.getParent() : null;
    }

    private IModelElement getModelElement(Object element) {
        if (element instanceof IModelElement) {
            return (IModelElement)element;
        }
        if (element instanceof IAdaptable) {
            return (IModelElement)((IAdaptable)element).getAdapter(IModelElement.class);
        }
        return null;
    }
}

