/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.dltk.mod.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public class MoveModifications
extends RefactoringModifications {
    private List fMoves = new ArrayList();
    private List fMoveArguments = new ArrayList();
    private List fParticipantDescriptorFilter = new ArrayList();

    public void move(IResource resource, MoveArguments args) {
        this.add(resource, (RefactoringArguments)args, null);
    }

    public void move(IProjectFragment sourceFolder, MoveArguments arguments) {
        this.add(sourceFolder, (RefactoringArguments)arguments, null);
        IResource sourceResource = sourceFolder.getResource();
        if (sourceResource != null) {
            this.getResourceModifications().addMove(sourceResource, new MoveArguments((Object)this.getResourceDestination(arguments), arguments.getUpdateReferences()));
            IFile buildpath = this.getBuildpathFile(sourceResource);
            if (buildpath != null) {
                this.getResourceModifications().addChanged(buildpath);
            }
            if ((buildpath = this.getBuildpathFile(this.getResourceDestination(arguments))) != null) {
                this.getResourceModifications().addChanged(buildpath);
            }
        }
    }

    public void move(IScriptFolder pack, MoveArguments args) throws CoreException {
        this.add(pack, (RefactoringArguments)args, null);
        if (pack.getResource() == null) {
            return;
        }
        IProjectFragment scriptDestination = (IProjectFragment)args.getDestination();
        if (scriptDestination.getResource() == null) {
            return;
        }
        IScriptFolder newPack = scriptDestination.getScriptFolder(pack.getElementName());
        if (!pack.hasSubfolders() && !newPack.exists()) {
            IContainer resourceDestination = newPack.getResource().getParent();
            this.createIncludingParents(resourceDestination);
            this.getResourceModifications().addMove(pack.getResource(), new MoveArguments((Object)resourceDestination, args.getUpdateReferences()));
        } else {
            IContainer resourceSource = (IContainer)pack.getResource();
            IContainer resourceDestination = (IContainer)newPack.getResource();
            this.createIncludingParents(resourceDestination);
            MoveArguments arguments = new MoveArguments((Object)resourceDestination, args.getUpdateReferences());
            IResource[] resourcesToMove = this.collectResourcesOfInterest(pack);
            HashSet<IResource> allMembers = new HashSet<IResource>(Arrays.asList(resourceSource.members()));
            int i = 0;
            while (i < resourcesToMove.length) {
                IResource toMove = resourcesToMove[i];
                this.getResourceModifications().addMove(toMove, arguments);
                allMembers.remove(toMove);
                ++i;
            }
            Iterator iter = allMembers.iterator();
            while (iter.hasNext()) {
                IResource element = (IResource)iter.next();
                if (!(element instanceof IFile)) continue;
                this.getResourceModifications().addDelete(element);
                iter.remove();
            }
            if (allMembers.isEmpty()) {
                this.getResourceModifications().addDelete((IResource)resourceSource);
            }
        }
    }

    public void move(ISourceModule unit, MoveArguments args) throws CoreException {
        this.add(unit, (RefactoringArguments)args, null);
        IType[] types = unit.getTypes();
        int tt = 0;
        while (tt < types.length) {
            this.add(types[tt], (RefactoringArguments)args, null);
            ++tt;
        }
        IResource resourceDestination = this.getResourceDestination(args);
        if (resourceDestination != null && unit.getResource() != null) {
            this.getResourceModifications().addMove(unit.getResource(), new MoveArguments((Object)resourceDestination, args.getUpdateReferences()));
        }
    }

    @Override
    public void buildDelta(IResourceChangeDescriptionFactory builder) {
        int i = 0;
        while (i < this.fMoves.size()) {
            Object element = this.fMoves.get(i);
            if (element instanceof IResource) {
                ResourceModifications.buildMoveDelta(builder, (IResource)element, (MoveArguments)this.fMoveArguments.get(i));
            }
            ++i;
        }
        this.getResourceModifications().buildDelta(builder);
    }

    @Override
    public void buildValidateEdits(ValidateEditChecker checker) {
        for (Object element : this.fMoves) {
            ISourceModule unit;
            IResource resource;
            if (!(element instanceof ISourceModule) || (resource = (unit = (ISourceModule)element).getResource()) == null || resource.getType() != 1) continue;
            checker.addFile((IFile)resource);
        }
    }

    @Override
    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor owner, String[] natures, SharableParticipants shared) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.fMoves.size()) {
            result.addAll(Arrays.asList(ParticipantManager.loadMoveParticipants((RefactoringStatus)status, (RefactoringProcessor)owner, this.fMoves.get(i), (MoveArguments)((MoveArguments)this.fMoveArguments.get(i)), (IParticipantDescriptorFilter)((IParticipantDescriptorFilter)this.fParticipantDescriptorFilter.get(i)), (String[])natures, (SharableParticipants)shared)));
            ++i;
        }
        result.addAll(Arrays.asList(this.getResourceModifications().getParticipants(status, owner, natures, shared)));
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void add(Object element, RefactoringArguments args, IParticipantDescriptorFilter filter) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)args);
        this.fMoves.add(element);
        this.fMoveArguments.add(args);
        this.fParticipantDescriptorFilter.add(filter);
    }

    private IResource getResourceDestination(MoveArguments args) {
        Object genericDestination = args.getDestination();
        IResource resourceDestination = null;
        if (genericDestination instanceof IModelElement) {
            resourceDestination = ((IModelElement)genericDestination).getResource();
        } else if (genericDestination instanceof IResource) {
            resourceDestination = (IResource)genericDestination;
        }
        return resourceDestination;
    }
}

