/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.mod.internal.corext.buildpath.BuildpathModifierOperation;
import org.eclipse.dltk.mod.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;

public class IncludeOperation
extends BuildpathModifierOperation {
    public IncludeOperation(BuildpathModifier.IBuildpathModifierListener listener, IBuildpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Include_tooltip, 8);
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            List elements = this.getSelectedElements();
            IScriptProject project = this.fInformationProvider.getScriptProject();
            result = this.include(elements, project, monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    @Override
    public boolean isValid(List elements, int[] types) throws ModelException {
        if (elements.size() == 0) {
            return false;
        }
        IScriptProject project = this.fInformationProvider.getScriptProject();
        int i = 0;
        while (i < elements.size()) {
            Object element = elements.get(i);
            switch (types[i]) {
                case 3: {
                    break;
                }
                case 6: {
                    if (this.isValidFolder((IResource)element, project)) break;
                    return false;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean isValidFolder(IResource resource, IScriptProject project) throws ModelException {
        if (project.isOnBuildpath((IModelElement)project) && resource.getProjectRelativePath().segmentCount() == 1) {
            IProjectFragment root1 = BuildpathModifier.getFragmentRoot(resource, project, null);
            IProjectFragment root2 = BuildpathModifier.getFragmentRoot(project.getResource(), project, null);
            if (root1 != null && root1.equals(root2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription(int type) {
        if (type == 3) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Include;
        }
        if (type == 4) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Include;
        }
        if (type == 6) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Include;
        }
        if (type == 7) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Include;
        }
        if (type == 8) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Include;
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Include;
    }
}

