/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.dltk.mod.core.PreferencesLookupDelegate;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.internal.launching.InterpreterMessages;
import org.eclipse.dltk.mod.launching.DebuggingEngineRunner;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.InterpreterConfig;
import org.eclipse.dltk.mod.utils.PlatformFileUtils;

public abstract class ExternalDebuggingEngineRunner
extends DebuggingEngineRunner {
    public ExternalDebuggingEngineRunner(IInterpreterInstall install) {
        super(install);
    }

    protected final InterpreterConfig addEngineConfig(InterpreterConfig config, PreferencesLookupDelegate delegate) throws CoreException {
        return this.addEngineConfig(config, delegate, null);
    }

    @Override
    protected final InterpreterConfig addEngineConfig(InterpreterConfig config, PreferencesLookupDelegate delegate, ILaunch launch) throws CoreException {
        IFileHandle file = this.getDebuggingEnginePath(delegate);
        if (file == null || file.toString().length() == 0) {
            this.abort(InterpreterMessages.errDebuggingEnginePathNotSpecified, null, 500);
        } else if (!file.isFile()) {
            this.abort(InterpreterMessages.errDebuggingEnginePathInvalid, null, 500);
        }
        return this.alterConfig(config, delegate);
    }

    protected abstract String getDebuggingEnginePreferenceKey();

    protected IFileHandle getDebuggingEnginePath(PreferencesLookupDelegate delegate) {
        IEnvironment env = this.getInstall().getEnvironment();
        String key = this.getDebuggingEnginePreferenceKey();
        String qualifier = this.getDebuggingEnginePreferenceQualifier();
        String pathKeyValue = delegate.getString(qualifier, key);
        String path = (String)EnvironmentPathUtils.decodePaths((String)pathKeyValue).get(env);
        if (path != null && !"".equals(path)) {
            return PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)env, (IPath)new Path(path));
        }
        return null;
    }

    protected String getDebuggingPreference(PreferencesLookupDelegate delegate, String key) {
        String qualifier = this.getDebuggingEnginePreferenceQualifier();
        return delegate.getString(qualifier, key);
    }

    protected abstract InterpreterConfig alterConfig(InterpreterConfig var1, PreferencesLookupDelegate var2) throws CoreException;
}

