/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.launching;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.utils.PlatformFileUtils;

public class LazyFileHandle
implements IFileHandle {
    private String environment = null;
    private IPath path = null;
    private IFileHandle handle = null;

    public LazyFileHandle(String environment, IPath path) {
        this.environment = environment;
        this.path = path;
    }

    private void initialize() {
        if (this.handle == null) {
            IEnvironment environment = EnvironmentManager.getEnvironmentById((String)this.environment);
            if (environment != null) {
                this.handle = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)environment, (IPath)this.path);
            } else if (this.environment.equals("")) {
                this.handle = EnvironmentManager.getLocalEnvironment().getFile(this.path);
            }
        }
    }

    public boolean exists() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.exists();
        }
        return false;
    }

    public String getCanonicalPath() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getCanonicalPath();
        }
        return null;
    }

    public IFileHandle getChild(String bundlePath) {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getChild(bundlePath);
        }
        return null;
    }

    public IFileHandle[] getChildren() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getChildren();
        }
        return null;
    }

    public IEnvironment getEnvironment() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getEnvironment();
        }
        return null;
    }

    public IPath getFullPath() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getFullPath();
        }
        return null;
    }

    public String getName() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getName();
        }
        return null;
    }

    public IFileHandle getParent() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getParent();
        }
        return null;
    }

    public IPath getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.isDirectory();
        }
        return false;
    }

    public boolean isFile() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.isFile();
        }
        return false;
    }

    public boolean isSymlink() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.isSymlink();
        }
        return false;
    }

    public long lastModified() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.lastModified();
        }
        return 0L;
    }

    public long length() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.length();
        }
        return 0L;
    }

    public InputStream openInputStream(IProgressMonitor monitor) throws IOException {
        this.initialize();
        if (this.handle != null) {
            return this.handle.openInputStream(monitor);
        }
        return null;
    }

    public String toOSString() {
        IEnvironment environment = EnvironmentManager.getEnvironmentById((String)this.environment);
        if (environment != null) {
            IPath newPath = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)environment, (IPath)this.path).getPath();
            return environment.convertPathToString(newPath);
        }
        this.initialize();
        if (this.handle != null) {
            return this.handle.toOSString();
        }
        return null;
    }

    public URI toURI() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.toURI();
        }
        return null;
    }

    public String getEnvironmentId() {
        if (this.environment.equals("")) {
            return "org.eclipse.dltk.mod.core.environment.localEnvironment";
        }
        return this.environment;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.environment == null ? 0 : this.environment.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        IEnvironment otherEnvironment;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof IFileHandle)) {
            return false;
        }
        IFileHandle other = (IFileHandle)obj;
        if (this.environment == null ? other.getEnvironment() != null : (otherEnvironment = other.getEnvironment()) == null || !this.environment.equals(otherEnvironment.getId())) {
            return false;
        }
        return !(this.path == null ? other.getPath() != null : !this.path.equals((Object)other.getPath()));
    }

    public String toString() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.toString();
        }
        return "[UNRESOLVED FILE HANDLE]";
    }
}

