/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp.internal;

import java.io.IOException;
import org.eclipse.dltk.mod.dbgp.IDbgpNotificationManager;
import org.eclipse.dltk.mod.dbgp.IDbgpRawListener;
import org.eclipse.dltk.mod.dbgp.IDbgpSession;
import org.eclipse.dltk.mod.dbgp.IDbgpSessionInfo;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpSpawnpointCommands;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.dbgp.internal.DbgpTermination;
import org.eclipse.dltk.mod.dbgp.internal.IDbgpDebugingEngine;
import org.eclipse.dltk.mod.dbgp.internal.IDbgpTerminationListener;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpCoreCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpDebuggingEngineCommunicator;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpExtendedCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpSpawnpointCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.mod.dbgp.internal.managers.DbgpNotificationManager;
import org.eclipse.dltk.mod.dbgp.internal.managers.DbgpStreamManager;
import org.eclipse.dltk.mod.dbgp.internal.managers.IDbgpStreamManager;
import org.eclipse.dltk.mod.dbgp.internal.packets.DbgpResponsePacket;
import org.eclipse.dltk.mod.dbgp.internal.utils.DbgpXmlEntityParser;
import org.eclipse.dltk.mod.debug.core.IDebugOptions;
import org.eclipse.dltk.mod.debug.core.model.DefaultDebugOptions;

public class DbgpSession
extends DbgpTermination
implements IDbgpSession,
IDbgpTerminationListener {
    private final IDbgpDebugingEngine engine;
    private final IDbgpCoreCommands coreCommands;
    private final IDbgpExtendedCommands extendedCommands;
    private final IDbgpSpawnpointCommands spawnpointCommands;
    private final DbgpNotificationManager notificationManager;
    private final DbgpStreamManager streamManager;
    private IDbgpSessionInfo info;
    private final Object terminatedLock = new Object();
    private boolean terminated = false;
    private DbgpDebuggingEngineCommunicator communicator;

    private void requestTerminateImpl(Object object) {
        if (object != this.engine) {
            this.engine.requestTermination();
        }
        if (object != this.streamManager && this.streamManager != null) {
            this.streamManager.requestTermination();
        }
        if (object != this.notificationManager && this.notificationManager != null) {
            this.notificationManager.requestTermination();
        }
    }

    private void waitTerminatedImpl(Object object) throws InterruptedException {
        if (object != this.engine) {
            this.engine.waitTerminated();
        }
        if (this.streamManager != null && object != this.streamManager) {
            this.streamManager.waitTerminated();
        }
        if (this.notificationManager != null && object != this.notificationManager) {
            this.notificationManager.waitTerminated();
        }
    }

    public DbgpSession(IDbgpDebugingEngine engine) throws DbgpException, IOException {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
        try {
            DbgpResponsePacket responsePacket = engine.getResponsePacket(-1, 0);
            if (responsePacket == null) {
                throw new DbgpException();
            }
            this.info = DbgpXmlEntityParser.parseSession(responsePacket.getContent());
        }
        catch (InterruptedException interruptedException) {}
        this.engine.addTerminationListener(this);
        this.notificationManager = new DbgpNotificationManager(engine);
        this.notificationManager.addTerminationListener(this);
        this.streamManager = new DbgpStreamManager(engine, "DBGP - Stream manager");
        this.streamManager.addTerminationListener(this);
        this.communicator = new DbgpDebuggingEngineCommunicator(engine, DefaultDebugOptions.getDefaultInstance());
        this.coreCommands = new DbgpCoreCommands(this.communicator);
        this.extendedCommands = new DbgpExtendedCommands(this.communicator);
        this.spawnpointCommands = new DbgpSpawnpointCommands(this.communicator, this);
        this.notificationManager.start();
        this.streamManager.start();
    }

    @Override
    public IDbgpSessionInfo getInfo() {
        return this.info;
    }

    public String toString() {
        return "Session. appid: " + this.info.getApplicationId();
    }

    @Override
    public IDbgpCoreCommands getCoreCommands() {
        return this.coreCommands;
    }

    @Override
    public IDbgpExtendedCommands getExtendedCommands() {
        return this.extendedCommands;
    }

    @Override
    public IDbgpStreamManager getStreamManager() {
        return this.streamManager;
    }

    @Override
    public IDbgpNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestTermination() {
        Object object = this.terminatedLock;
        synchronized (object) {
            if (this.terminated) {
                return;
            }
            this.requestTerminateImpl(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitTerminated() throws InterruptedException {
        Object object = this.terminatedLock;
        synchronized (object) {
            if (this.terminated) {
                return;
            }
            this.waitTerminatedImpl(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectTerminated(Object object, Exception e) {
        Object object2 = this.terminatedLock;
        synchronized (object2) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
        }
        this.engine.removeTerminationListener(this);
        if (this.streamManager != null) {
            this.streamManager.removeTerminationListener(this);
        }
        if (this.notificationManager != null) {
            this.notificationManager.removeTerminationListener(this);
        }
        this.requestTerminateImpl(object);
        try {
            this.waitTerminatedImpl(object);
        }
        catch (InterruptedException interruptedException) {}
        this.fireObjectTerminated(e);
    }

    @Override
    public void addRawListener(IDbgpRawListener listener) {
        this.engine.addRawListener(listener);
    }

    @Override
    public void removeRawListenr(IDbgpRawListener listener) {
        this.engine.removeRawListenr(listener);
    }

    @Override
    public IDbgpCommunicator getCommunicator() {
        return this.communicator;
    }

    @Override
    public void configure(IDebugOptions debugOptions) {
        this.communicator.configure(debugOptions);
    }

    @Override
    public Object get(Class type) {
        if (type == IDbgpSpawnpointCommands.class) {
            return this.spawnpointCommands;
        }
        if (type == IDbgpCoreCommands.class) {
            return this.coreCommands;
        }
        if (type == IDbgpExtendedCommands.class) {
            return this.extendedCommands;
        }
        return null;
    }
}

