/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.css.dom.impl;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.css.parser.CSSLexicalUnit;
import org.eclipse.vjet.dsf.css.dom.IHslColor;
import org.eclipse.vjet.dsf.css.dom.IHslaColor;
import org.eclipse.vjet.dsf.css.dom.IRgbaColor;
import org.eclipse.vjet.dsf.css.dom.impl.DCssCounter;
import org.eclipse.vjet.dsf.css.dom.impl.DCssException;
import org.eclipse.vjet.dsf.css.dom.impl.DCssRect;
import org.eclipse.vjet.dsf.css.dom.impl.DCssRgbColor;
import org.eclipse.vjet.dsf.css.parser.DCssBuilder;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class DCssValue
implements CSSPrimitiveValue,
CSSValueList,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Object m_value = null;

    public DCssValue(LexicalUnit value, boolean forcePrimitive) {
        if (value.getNextLexicalUnit() == null) {
            switch (value.getLexicalUnitType()) {
                case 38: {
                    this.m_value = new DCssRect(value.getParameters());
                    break;
                }
                case 27: {
                    this.m_value = new DCssRgbColor(value.getParameters());
                    break;
                }
                case 25: {
                    this.m_value = new DCssCounter(false, value.getParameters());
                    break;
                }
                case 26: {
                    this.m_value = new DCssCounter(true, value.getParameters());
                    break;
                }
                default: {
                    this.m_value = value;
                    break;
                }
            }
        } else if (forcePrimitive || value.getNextLexicalUnit() == null) {
            this.m_value = value;
        } else {
            ArrayList<DCssValue> v = new ArrayList<DCssValue>();
            LexicalUnit lu = value;
            while (lu != null) {
                if (lu.getLexicalUnitType() != 0 && lu.getLexicalUnitType() != 4) {
                    v.add(new DCssValue(lu, true));
                }
                lu = lu.getNextLexicalUnit();
            }
            this.m_value = v;
        }
    }

    public DCssValue(LexicalUnit value) {
        this(value, false);
    }

    @Override
    public String getCssText() {
        if (this.getCssValueType() == 2) {
            StringBuffer sb = new StringBuffer();
            List v = (List)this.m_value;
            LexicalUnit lu = (LexicalUnit)((DCssValue)v.get((int)0)).m_value;
            while (lu != null) {
                sb.append(lu.toString());
                LexicalUnit prev = lu;
                lu = lu.getNextLexicalUnit();
                if (lu == null || lu.getLexicalUnitType() == 0 || lu.getLexicalUnitType() == 4 || prev.getLexicalUnitType() == 4) continue;
                sb.append(" ");
            }
            return sb.toString();
        }
        return this.m_value.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            DCssBuilder parser = new DCssBuilder();
            DCssValue v2 = parser.parsePropertyValue(is);
            this.m_value = v2.m_value;
        }
        catch (Exception e) {
            throw new DCssException(12, 0, e.getMessage());
        }
    }

    @Override
    public short getCssValueType() {
        if (this.m_value instanceof List) {
            return 2;
        }
        if (this.m_value instanceof LexicalUnit && ((LexicalUnit)this.m_value).getLexicalUnitType() == 12) {
            return 0;
        }
        return 1;
    }

    @Override
    public short getPrimitiveType() {
        if (this.m_value instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this.m_value;
            switch (lu.getLexicalUnitType()) {
                case 12: {
                    return 21;
                }
                case 13: 
                case 14: {
                    return 1;
                }
                case 15: {
                    return 3;
                }
                case 16: {
                    return 4;
                }
                case 17: {
                    return 5;
                }
                case 18: {
                    return 8;
                }
                case 19: {
                    return 6;
                }
                case 20: {
                    return 7;
                }
                case 21: {
                    return 9;
                }
                case 22: {
                    return 10;
                }
                case 23: {
                    return 2;
                }
                case 24: {
                    return 20;
                }
                case 28: {
                    return 11;
                }
                case 29: {
                    return 13;
                }
                case 30: {
                    return 12;
                }
                case 31: {
                    return 14;
                }
                case 32: {
                    return 15;
                }
                case 33: {
                    return 17;
                }
                case 34: {
                    return 16;
                }
                case 35: {
                    return 21;
                }
                case 36: {
                    return 19;
                }
                case 37: {
                    return 22;
                }
                case 39: 
                case 40: 
                case 41: {
                    return 19;
                }
                case 42: {
                    return 18;
                }
            }
        } else {
            if (this.m_value instanceof Rect) {
                return 24;
            }
            if (this.m_value instanceof RGBColor) {
                return 25;
            }
            if (this.m_value instanceof Counter) {
                return 23;
            }
        }
        return 0;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        this.m_value = CSSLexicalUnit.createFloat((short)unitType, (float)floatValue, null);
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        if (this.m_value instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this.m_value;
            return lu.getFloatValue();
        }
        throw new DCssException(15, 10);
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        switch (stringType) {
            case 19: {
                this.m_value = CSSLexicalUnit.createString((short)stringType, (String)stringValue, null);
                break;
            }
            case 22: {
                throw new DCssException(9, 19);
            }
            default: {
                throw new DCssException(15, 11);
            }
        }
    }

    @Override
    public String getStringValue() throws DOMException {
        if (this.m_value instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this.m_value;
            if (lu.getLexicalUnitType() == 35 || lu.getLexicalUnitType() == 36 || lu.getLexicalUnitType() == 24 || lu.getLexicalUnitType() == 37) {
                return lu.getStringValue();
            }
        } else if (this.m_value instanceof List) {
            return null;
        }
        throw new DCssException(15, 11);
    }

    @Override
    public Counter getCounterValue() throws DOMException {
        if (!(this.m_value instanceof Counter)) {
            throw new DCssException(15, 12);
        }
        return (Counter)this.m_value;
    }

    @Override
    public Rect getRectValue() throws DOMException {
        if (!(this.m_value instanceof Rect)) {
            throw new DCssException(15, 13);
        }
        return (Rect)this.m_value;
    }

    @Override
    public RGBColor getRGBColorValue() throws DOMException {
        if (!(this.m_value instanceof RGBColor)) {
            throw new DCssException(15, 14);
        }
        return (RGBColor)this.m_value;
    }

    public IRgbaColor getRGBAColorValue() throws DOMException {
        if (!(this.m_value instanceof IRgbaColor)) {
            throw new DCssException(15, 20);
        }
        return (IRgbaColor)this.m_value;
    }

    public IHslColor getHSLColorValue() throws DOMException {
        if (!(this.m_value instanceof IHslColor)) {
            throw new DCssException(15, 21);
        }
        return (IHslColor)this.m_value;
    }

    public IHslaColor getHSLAColorValue() throws DOMException {
        if (!(this.m_value instanceof IHslaColor)) {
            throw new DCssException(15, 22);
        }
        return (IHslaColor)this.m_value;
    }

    @Override
    public int getLength() {
        return this.m_value instanceof List ? ((List)this.m_value).size() : 0;
    }

    @Override
    public CSSValue item(int index) {
        return this.m_value instanceof List ? (CSSValue)((List)this.m_value).get(index) : null;
    }

    public String toString() {
        return this.getCssText();
    }

    public Object clone() throws CloneNotSupportedException {
        DCssValue copy = (DCssValue)super.clone();
        if (copy.m_value instanceof DCssRect) {
            copy.m_value = ((DCssRect)copy.m_value).clone();
        } else if (copy.m_value instanceof DCssRgbColor) {
            copy.m_value = ((DCssRgbColor)copy.m_value).clone();
        } else if (copy.m_value instanceof DCssCounter) {
            copy.m_value = ((DCssCounter)copy.m_value).clone();
        } else if (copy.m_value instanceof List) {
            copy.m_value = ((ArrayList)copy.m_value).clone();
        }
        return copy;
    }
}

