/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.css.dom.impl;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.vjet.dsf.css.dom.impl.DCssException;
import org.eclipse.vjet.dsf.css.dom.impl.DCssProperty;
import org.eclipse.vjet.dsf.css.dom.impl.DCssValue;
import org.eclipse.vjet.dsf.css.parser.DCssBuilder;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class DCssStyleDeclaration
implements CSSStyleDeclaration,
Serializable,
Cloneable {
    private static final long serialVersionUID = 200152048848468958L;
    static final String PRIORITY_IMPORTANT = "important";
    private CSSRule m_parentRule;
    private ArrayList<DCssProperty> m_properties = new ArrayList(5);
    private String m_text = null;

    public DCssStyleDeclaration(CSSRule parentRule) {
        this.m_parentRule = parentRule;
    }

    @Override
    public String getCssText() {
        if (this.m_text != null) {
            return this.m_text;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        int i = 0;
        while (i < this.m_properties.size()) {
            DCssProperty p = this.m_properties.get(i);
            if (p != null) {
                sb.append(p.toString());
            }
            if (i < this.m_properties.size() - 1) {
                sb.append("; ");
            }
            ++i;
        }
        sb.append("}");
        this.m_text = sb.toString();
        return this.m_text;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.m_text = null;
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            DCssBuilder parser = new DCssBuilder();
            this.m_properties.clear();
            parser.parseStyleDeclaration(this, is);
        }
        catch (Exception e) {
            throw new DCssException(12, 0, e.getMessage());
        }
    }

    @Override
    public String getPropertyValue(String propertyName) {
        DCssProperty p = this.getPropertyDeclaration(propertyName);
        return p != null ? p.getValue().toString() : "";
    }

    public String getPropertyValue(int propertyIndex) {
        return this.m_properties.get(propertyIndex).getValue().toString();
    }

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        DCssProperty p = this.getPropertyDeclaration(propertyName);
        return p != null ? p.getValue() : null;
    }

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        this.m_text = null;
        int i = 0;
        while (i < this.m_properties.size()) {
            DCssProperty p = this.m_properties.get(i);
            if (p.getName().equalsIgnoreCase(propertyName)) {
                this.m_properties.remove(i);
                return p.getValue().toString();
            }
            ++i;
        }
        return "";
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        DCssProperty p = this.getPropertyDeclaration(propertyName);
        if (p != null) {
            return p.isImportant() ? PRIORITY_IMPORTANT : "";
        }
        return "";
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        this.m_text = null;
        try {
            InputSource is = new InputSource((Reader)new StringReader(value.trim()));
            DCssBuilder parser = new DCssBuilder();
            DCssValue expr = parser.parsePropertyValue(is);
            DCssProperty p = this.getPropertyDeclaration(propertyName);
            boolean important = PRIORITY_IMPORTANT.equalsIgnoreCase(priority);
            if (p == null) {
                p = new DCssProperty(propertyName, expr, important);
                this.addProperty(p);
            } else {
                p.setValue(expr);
                p.setImportant(important);
            }
        }
        catch (Exception e) {
            throw new DCssException(12, 0, e.getMessage());
        }
    }

    @Override
    public int getLength() {
        return this.m_properties.size();
    }

    @Override
    public String item(int index) {
        DCssProperty p = this.m_properties.get(index);
        return p != null ? p.getName() : "";
    }

    @Override
    public CSSRule getParentRule() {
        return this.m_parentRule;
    }

    public CSSStyleDeclaration addProperty(DCssProperty p) {
        this.m_text = null;
        this.m_properties.add(p);
        return this;
    }

    public DCssProperty getPropertyDeclaration(int indexPosition) {
        return this.m_properties.get(indexPosition);
    }

    public DCssProperty getPropertyDeclaration(String name) {
        int i = 0;
        while (i < this.m_properties.size()) {
            DCssProperty p = this.m_properties.get(i);
            if (p.getName().equalsIgnoreCase(name)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return this.getCssText();
    }

    public Object clone() throws CloneNotSupportedException {
        DCssStyleDeclaration clone = (DCssStyleDeclaration)super.clone();
        clone.m_properties = (ArrayList)this.m_properties.clone();
        int i = 0;
        while (i < clone.m_properties.size()) {
            clone.m_properties.set(i, (DCssProperty)clone.m_properties.get(i).clone());
            ++i;
        }
        return clone;
    }
}

