/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStore;
import org.eclipse.virgo.util.io.PathReference;

public abstract class AbstractArtifactStore
implements ArtifactStore {
    private boolean saved = false;
    protected final Object monitor = new Object();

    public AbstractArtifactStore(PathReference basePathReference) {
        if (basePathReference == null) {
            throw new IllegalArgumentException("Null path");
        }
        if ("".equals(basePathReference.getName())) {
            throw new IllegalArgumentException("Empty filename");
        }
    }

    @Override
    public abstract PathReference getCurrentPath();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Object object = this.monitor;
        synchronized (object) {
            this.saved = true;
            PathReference currentPathReference = this.getCurrentPath();
            currentPathReference.getParent().createDirectory();
            currentPathReference.delete(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore() {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.saved) {
                throw new IllegalStateException("No saved artifact available");
            }
            this.getCurrentPath().delete(true);
            this.saved = false;
        }
    }

    protected abstract PathReference getSavedPath();
}

