/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.impl.StringEscapeUtils;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.sockjs.SockJSSocket;
import org.vertx.java.core.sockjs.impl.Session;
import org.vertx.java.core.sockjs.impl.Transport;
import org.vertx.java.core.sockjs.impl.TransportListener;

class BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(BaseTransport.class);
    protected final VertxInternal vertx;
    protected final Map<String, Session> sessions;
    protected JsonObject config;
    protected static final String COMMON_PATH_ELEMENT_RE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/";
    private static final long RAND_OFFSET = 0x80000000L;

    public BaseTransport(VertxInternal vertx, Map<String, Session> sessions, JsonObject config) {
        this.vertx = vertx;
        this.sessions = sessions;
        this.config = config;
    }

    protected Session getSession(long timeout, long heartbeatPeriod, String sessionID, Handler<SockJSSocket> sockHandler) {
        Session session = this.sessions.get(sessionID);
        if (session == null) {
            session = new Session(this.vertx, this.sessions, sessionID, timeout, heartbeatPeriod, sockHandler);
            this.sessions.put(sessionID, session);
        }
        return session;
    }

    protected void sendInvalidJSON(HttpServerResponse response) {
        if (log.isTraceEnabled()) {
            log.trace("Broken JSON");
        }
        response.setStatusCode(500);
        response.end("Broken JSON encoding.");
    }

    protected String escapeForJavaScript(String str) {
        try {
            str = StringEscapeUtils.escapeJavaScript(str);
        }
        catch (Exception e) {
            log.error("Failed to escape", e);
            str = null;
        }
        return str;
    }

    static void setJSESSIONID(JsonObject config, HttpServerRequest req) {
        String cookies = req.headers().get("cookie");
        if (config.getBoolean("insert_JSESSIONID").booleanValue()) {
            if (cookies != null) {
                String[] parts = cookies.contains(";") ? cookies.split(";") : new String[]{cookies};
                for (String part : parts) {
                    if (!part.startsWith("JSESSIONID")) continue;
                    cookies = part + "; path=/";
                    break;
                }
            }
            if (cookies == null) {
                cookies = "JSESSIONID=dummy; path=/";
            }
            req.response().headers().set("Set-Cookie", cookies);
        }
    }

    static void setCORS(HttpServerRequest req) {
        String origin = req.headers().get("origin");
        if (origin == null || "null".equals(origin)) {
            origin = "*";
        }
        req.response().headers().set("Access-Control-Allow-Origin", origin);
        req.response().headers().set("Access-Control-Allow-Credentials", "true");
        String hdr = req.headers().get("Access-Control-Request-Headers");
        if (hdr != null) {
            req.response().headers().set("Access-Control-Allow-Headers", hdr);
        }
    }

    static Handler<HttpServerRequest> createInfoHandler(final JsonObject config) {
        return new Handler<HttpServerRequest>(){
            boolean websocket;
            {
                this.websocket = !config.getArray("disabled_transports").contains(Transport.WEBSOCKET.toString());
            }

            @Override
            public void handle(HttpServerRequest req) {
                if (log.isTraceEnabled()) {
                    log.trace("In Info handler");
                }
                req.response().headers().set("Content-Type", "application/json; charset=UTF-8");
                BaseTransport.setNoCacheHeaders(req);
                JsonObject json = new JsonObject();
                json.putBoolean("websocket", this.websocket);
                json.putBoolean("cookie_needed", config.getBoolean("insert_JSESSIONID"));
                json.putArray("origins", new JsonArray().add("*:*"));
                json.putNumber("entropy", 0x80000000L + (long)new Random().nextInt());
                BaseTransport.setCORS(req);
                req.response().end(json.encode());
            }
        };
    }

    static void setNoCacheHeaders(HttpServerRequest req) {
        req.response().headers().set("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
    }

    static Handler<HttpServerRequest> createCORSOptionsHandler(final JsonObject config, final String methods) {
        return new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest req) {
                if (log.isTraceEnabled()) {
                    log.trace("In CORS options handler");
                }
                req.response().headers().set("Cache-Control", "public,max-age=31536000");
                long oneYearSeconds = 31536000L;
                long oneYearms = oneYearSeconds * 1000L;
                String expires = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(new Date(System.currentTimeMillis() + oneYearms));
                req.response().headers().set("Expires", expires);
                req.response().headers().set("Access-Control-Allow-Methods", methods);
                req.response().headers().set("Access-Control-Max-Age", String.valueOf(oneYearSeconds));
                BaseTransport.setCORS(req);
                BaseTransport.setJSESSIONID(config, req);
                req.response().setStatusCode(204);
                req.response().end();
            }
        };
    }

    static MultiMap removeCookieHeaders(MultiMap headers) {
        String jsessionid = null;
        for (String cookie : headers.getAll("cookie")) {
            if (!cookie.startsWith("JSESSIONID=")) continue;
            jsessionid = cookie;
        }
        headers.remove("cookie");
        if (jsessionid != null) {
            headers.add("cookie", jsessionid);
        }
        return headers;
    }

    protected static abstract class BaseListener
    implements TransportListener {
        protected final HttpServerRequest req;
        protected final Session session;
        protected boolean closed;

        protected BaseListener(HttpServerRequest req, Session session) {
            this.req = req;
            this.session = session;
        }

        protected void addCloseHandler(HttpServerResponse resp, final Session session) {
            resp.closeHandler(new VoidHandler(){

                @Override
                public void handle() {
                    if (log.isTraceEnabled()) {
                        log.trace("Connection closed (from client?), closing session");
                    }
                    session.shutdown();
                    BaseListener.this.closed = true;
                }
            });
        }

        @Override
        public void sessionClosed() {
            this.session.writeClosed(this);
            this.close();
        }
    }
}

