/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.tests.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.userstorage.StorageFactory;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.spi.ISettings;
import org.eclipse.userstorage.tests.util.Fixture;
import org.eclipse.userstorage.tests.util.ServerFixture;
import org.eclipse.userstorage.util.FileStorageCache;
import org.eclipse.userstorage.util.Settings;

public class ClientFixture
extends Fixture {
    private static final File CACHE = new File(TEST_FOLDER, "cache");
    private final String applicationToken;
    private final StorageFactory factory;
    private final TestCache cache;

    public ClientFixture(ServerFixture serverFixture) throws Exception {
        this.applicationToken = serverFixture.getApplicationToken();
        String serviceURI = serverFixture.getService().getServiceURI().toString();
        Settings.MemorySettings settings = new Settings.MemorySettings();
        settings.setValue(this.applicationToken, serviceURI);
        this.factory = new StorageFactory((ISettings)settings);
        this.cache = this.createCache();
    }

    public String getApplicationToken() {
        return this.applicationToken;
    }

    public final StorageFactory getFactory() {
        return this.factory;
    }

    public final TestCache getCache() {
        return this.cache;
    }

    public final String readCache(String key, String extension) throws IOException {
        try {
            return IOUtil.readUTF((File)this.cache.getFile(this.applicationToken, key, extension));
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw ex;
        }
    }

    protected TestCache createCache() {
        IOUtil.deleteFiles((File)CACHE);
        return new TestCache(CACHE);
    }

    public static final class TestCache
    extends FileStorageCache {
        public TestCache(File folder) {
            super(folder);
        }

        public File getFile(String applicationToken, String key, String extension) {
            return super.getFile(applicationToken, key, extension);
        }
    }
}

