/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TitanBitString;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanBitString_Element {
    private boolean bound_flag;
    private final TitanBitString str_val;
    private final int bit_pos;

    public TitanBitString_Element(boolean par_bound_flag, TitanBitString par_str_val, int par_bit_pos) {
        this.bound_flag = par_bound_flag;
        this.str_val = par_str_val;
        this.bit_pos = par_bit_pos;
    }

    public boolean is_bound() {
        return this.bound_flag;
    }

    public boolean is_value() {
        return this.is_bound();
    }

    public void must_bound(String errorMessage) {
        if (!this.bound_flag) {
            throw new TtcnError(errorMessage);
        }
    }

    public TitanBitString_Element operator_assign(TitanBitString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound bitstring element.");
        this.bound_flag = true;
        this.str_val.set_bit(this.bit_pos, otherValue.str_val.get_bit(otherValue.bit_pos));
        return this;
    }

    public TitanBitString_Element operator_assign(TitanBitString otherValue) {
        otherValue.must_bound("Assignment of unbound bitstring value.");
        if (otherValue.lengthof().get_int() != 1) {
            throw new TtcnError("Assignment of a bitstring value with length other than 1 to a bitstring element.");
        }
        this.bound_flag = true;
        this.str_val.set_bit(this.bit_pos, otherValue.get_bit(0));
        return this;
    }

    public boolean operator_equals(TitanBitString_Element otherValue) {
        this.must_bound("Unbound left operand of bitstring element comparison.");
        otherValue.must_bound("Unbound right operand of bitstring comparison.");
        return this.str_val.get_bit(this.bit_pos) == otherValue.str_val.get_bit(otherValue.bit_pos);
    }

    public boolean operator_equals(TitanBitString otherValue) {
        this.must_bound("Unbound left operand of bitstring element comparison.");
        otherValue.must_bound("Unbound right operand of bitstring element comparison.");
        if (otherValue.lengthof().get_int() != 1) {
            return false;
        }
        return this.str_val.get_bit(this.bit_pos) == otherValue.get_bit(0);
    }

    public boolean operator_not_equals(TitanBitString_Element otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanBitString otherValue) {
        return !this.operator_equals(otherValue);
    }

    public TitanBitString operator_concatenate(TitanBitString other_value) {
        this.must_bound("Unbound left operand of bitstring element concatenation.");
        other_value.must_bound("Unbound right operand of bitstring concatenation.");
        int n_bits = other_value.lengthof().get_int();
        int n_bytes = (n_bits + 7) / 8;
        int[] result = new int[n_bytes];
        int[] temp = other_value.get_value();
        result[0] = this.get_bit() ? 1 : 0;
        for (int byte_count = 0; byte_count < n_bytes; ++byte_count) {
            result[byte_count] = (result[byte_count] | temp[byte_count] << 1) & 0xFF;
            if (n_bits <= byte_count * 8 + 7) continue;
            result[byte_count + 1] = (temp[byte_count] & 0x80) >> 7;
        }
        return new TitanBitString(result, n_bits + 1);
    }

    public TitanBitString operator_concatenate(TitanBitString_Element other_value) {
        int result;
        this.must_bound("Unbound left operand of bitstring element concatenation.");
        other_value.must_bound("Unbound right operand of bitstring element concatenation.");
        int n = result = this.str_val.get_bit(this.bit_pos) ? 1 : 2;
        if (other_value.get_bit()) {
            result |= 2;
        }
        int[] temp_ptr = new int[]{result};
        return new TitanBitString(temp_ptr, 2);
    }

    public TitanBitString not4b() {
        this.must_bound("Unbound bitstring element operand of operator not4b.");
        int result = this.str_val.get_bit(this.bit_pos) ? 0 : 1;
        int[] dest_ptr = new int[]{result};
        return new TitanBitString(dest_ptr, 1);
    }

    public TitanBitString and4b(TitanBitString otherValue) {
        this.must_bound("Left operand of operator and4b is an unbound bitstring element.");
        otherValue.must_bound("Right operand of operator and4b is an unbound bitstring value.");
        if (otherValue.lengthof().get_int() != 1) {
            throw new TtcnError("The bitstring operands of operator and4b must have the same length.");
        }
        boolean temp = this.str_val.get_bit(this.bit_pos) & otherValue.get_bit(0);
        int result = temp ? 1 : 0;
        int[] dest_ptr = new int[]{result};
        return new TitanBitString(dest_ptr, 1);
    }

    public TitanBitString and4b(TitanBitString_Element otherValue) {
        this.must_bound("Left operand of operator and4b is an unbound bitstring element.");
        otherValue.must_bound("Right operand of operator and4b is an unbound bitstring element.");
        boolean temp = this.str_val.get_bit(this.bit_pos) & otherValue.get_bit();
        int result = temp ? 1 : 0;
        int[] dest_ptr = new int[]{result};
        return new TitanBitString(dest_ptr, 1);
    }

    public TitanBitString or4b(TitanBitString otherValue) {
        this.must_bound("Left operand of operator or4b is an unbound bitstring element.");
        otherValue.must_bound("Right operand of operator or4b is an unbound bitstring value.");
        if (otherValue.lengthof().get_int() != 1) {
            throw new TtcnError("The bitstring operands of operator or4b must have the same length.");
        }
        boolean temp = this.str_val.get_bit(this.bit_pos) | otherValue.get_bit(0);
        int result = temp ? 1 : 0;
        int[] dest_ptr = new int[]{result};
        return new TitanBitString(dest_ptr, 1);
    }

    public TitanBitString or4b(TitanBitString_Element otherValue) {
        this.must_bound("Left operand of operator or4b is an unbound bitstring element.");
        otherValue.must_bound("Right operand of operator or4b is an unbound bitstring element.");
        boolean temp = this.str_val.get_bit(this.bit_pos) | otherValue.get_bit();
        int result = temp ? 1 : 0;
        int[] dest_ptr = new int[]{result};
        return new TitanBitString(dest_ptr, 1);
    }

    public TitanBitString xor4b(TitanBitString otherValue) {
        this.must_bound("Left operand of operator xor4b is an unbound bitstring element.");
        otherValue.must_bound("Right operand of operator xor4b is an unbound bitstring value.");
        if (otherValue.lengthof().get_int() != 1) {
            throw new TtcnError("The bitstring operands of operator xor4b must have the same length.");
        }
        boolean temp = this.str_val.get_bit(this.bit_pos) ^ otherValue.get_bit(0);
        int result = temp ? 1 : 0;
        int[] dest_ptr = new int[]{result};
        return new TitanBitString(dest_ptr, 1);
    }

    public TitanBitString xor4b(TitanBitString_Element otherValue) {
        this.must_bound("Left operand of operator xor4b is an unbound bitstring element.");
        otherValue.must_bound("Right operand of operator xor4b is an unbound bitstring element.");
        boolean temp = this.str_val.get_bit(this.bit_pos) ^ otherValue.get_bit();
        int result = temp ? 1 : 0;
        int[] dest_ptr = new int[]{result};
        return new TitanBitString(dest_ptr, 1);
    }

    public TitanBitString shift_left(int shift_count) {
        this.must_bound("Unbound bitstring element operand of shift left operator.");
        if (shift_count == 0) {
            return new TitanBitString(this);
        }
        return new TitanBitString("0");
    }

    public TitanBitString shift_left(TitanInteger shift_count) {
        shift_count.must_bound("Unbound right operand of shift left operator.");
        return this.shift_left(shift_count.get_int());
    }

    public TitanBitString shift_right(int shift_count) {
        this.must_bound("Unbound bitstring element operand of shift right operator.");
        if (shift_count == 0) {
            return new TitanBitString(this);
        }
        return new TitanBitString("0");
    }

    public TitanBitString shift_right(TitanInteger shift_count) {
        shift_count.must_bound("Unbound bitstring operand of shift left operator.");
        return this.shift_right(shift_count.get_int());
    }

    public TitanBitString rotate_left(int rotate_count) {
        this.must_bound("Unbound bitstring element operand of rotate left operator.");
        return new TitanBitString(this);
    }

    public TitanBitString rotate_left(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound right operand of rotate left operator.");
        return this.rotate_left(rotate_count.get_int());
    }

    public TitanBitString rotate_right(int rotate_count) {
        this.must_bound("Unbound bitstring element operand of rotate right operator.");
        return new TitanBitString(this);
    }

    public TitanBitString rotate_right(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound right operand of rotate right operator.");
        return this.rotate_right(rotate_count.get_int());
    }

    public boolean get_bit() {
        return this.str_val.get_bit(this.bit_pos);
    }

    public void log() {
        if (this.bound_flag) {
            TTCN_Logger.log_char('\'');
            TTCN_Logger.log_char(this.str_val.get_bit(this.bit_pos) ? (char)'1' : '0');
            TTCN_Logger.log_event_str("'B");
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('\'');
        result.append(this.str_val.get_bit(this.bit_pos) ? (char)'1' : '0');
        result.append("'B");
        return result.toString();
    }
}

