/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class UnnecessaryArrays
extends BaseModuleCodeSmellSpotter {
    private static final String ERROR_MESSAGE = "Arrays can slow compilation, consider using record of types";
    protected final CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();

    public UnnecessaryArrays() {
        super(CodeSmellType.UNNECESSARY_ARRAYS);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (!(node instanceof Def_Const) && !(node instanceof Def_Var)) {
            return;
        }
        Definition s = (Definition)node;
        if (s.getType(this.timestamp) instanceof Array_Type) {
            problems.report(s.getLocation(), ERROR_MESSAGE);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(Def_Var.class);
        ret.add(Def_Const.class);
        return ret;
    }
}

