/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.common.parsers.IntervalDetector;
import org.eclipse.titan.designer.editors.IHeuristicalIntervalDetector;

public final class HeuristicalIntervalDetector
extends IntervalDetector
implements IHeuristicalIntervalDetector {
    public synchronized Interval buildIntervals(IDocument document) {
        String text = document.get();
        int rangeEnd = text.length();
        this.initRootInterval(text.length());
        int actualLine = 0;
        boolean insideString = false;
        try {
            block24: for (int nextPos = 0; nextPos < rangeEnd; ++nextPos) {
                switch (text.charAt(nextPos)) {
                    case '(': {
                        if (insideString || this.actualInterval.isComment()) continue block24;
                        this.pushInterval(nextPos, actualLine, Interval.interval_type.PARAMETER);
                        continue block24;
                    }
                    case ')': {
                        if (insideString || !Interval.interval_type.PARAMETER.equals((Object)this.actualInterval.getType())) continue block24;
                        this.popInterval(nextPos, actualLine);
                        continue block24;
                    }
                    case '[': {
                        if (insideString || this.actualInterval.isComment()) continue block24;
                        this.pushInterval(nextPos, actualLine, Interval.interval_type.INDEX);
                        continue block24;
                    }
                    case ']': {
                        if (insideString || !Interval.interval_type.INDEX.equals((Object)this.actualInterval.getType())) continue block24;
                        this.popInterval(nextPos, actualLine);
                        continue block24;
                    }
                    case '{': {
                        if (insideString || this.actualInterval.isComment()) continue block24;
                        this.pushInterval(nextPos, actualLine, Interval.interval_type.NORMAL);
                        continue block24;
                    }
                    case '}': {
                        if (insideString || !Interval.interval_type.NORMAL.equals((Object)this.actualInterval.getType())) continue block24;
                        this.popInterval(nextPos, actualLine);
                        continue block24;
                    }
                    case '/': {
                        if (insideString || this.actualInterval.isComment() || nextPos + 1 >= rangeEnd) continue block24;
                        switch (text.charAt(nextPos + 1)) {
                            case '*': {
                                this.pushInterval(nextPos, actualLine, Interval.interval_type.MULTILINE_COMMENT);
                                ++nextPos;
                                continue block24;
                            }
                            case '/': {
                                this.pushInterval(nextPos, actualLine, Interval.interval_type.SINGLELINE_COMMENT);
                                ++nextPos;
                                continue block24;
                            }
                        }
                        continue block24;
                    }
                    case '*': {
                        if (insideString || !Interval.interval_type.MULTILINE_COMMENT.equals((Object)this.actualInterval.getType()) || nextPos + 1 >= rangeEnd || '/' != text.charAt(nextPos + 1)) continue block24;
                        this.popInterval(nextPos, actualLine);
                        ++nextPos;
                        continue block24;
                    }
                    case '\"': {
                        if (nextPos - 1 <= 0 || '\\' == text.charAt(nextPos - 1) || this.actualInterval.isComment()) continue block24;
                        insideString = !insideString;
                        continue block24;
                    }
                    case '#': {
                        if (insideString || this.actualInterval.isComment()) continue block24;
                        this.pushInterval(nextPos, actualLine, Interval.interval_type.SINGLELINE_COMMENT);
                        continue block24;
                    }
                    case '\n': {
                        if (Interval.interval_type.SINGLELINE_COMMENT.equals((Object)this.actualInterval.getType())) {
                            int actualPosition = nextPos;
                            boolean whitespace = true;
                            int linesCrossed = 0;
                            block25: while (nextPos < rangeEnd && whitespace && linesCrossed < 2) {
                                switch (text.charAt(nextPos)) {
                                    case '\n': {
                                        ++linesCrossed;
                                        ++nextPos;
                                        ++actualLine;
                                        continue block25;
                                    }
                                    case '\r': {
                                        if (++nextPos >= rangeEnd || text.charAt(nextPos) != '\n') continue block25;
                                        ++nextPos;
                                        ++linesCrossed;
                                        ++actualLine;
                                        continue block25;
                                    }
                                    case '\t': 
                                    case ' ': {
                                        ++nextPos;
                                        continue block25;
                                    }
                                }
                                whitespace = false;
                            }
                            if (linesCrossed >= 2 || nextPos + 1 >= rangeEnd) {
                                this.popInterval(actualPosition, actualLine);
                            } else {
                                char temp = text.charAt(this.actualInterval.getStartOffset());
                                if (temp == '/' && (text.charAt(nextPos) != '/' || text.charAt(nextPos + 1) != '/')) {
                                    this.popInterval(actualPosition, actualLine);
                                } else if (temp == '#' && text.charAt(nextPos) != '#') {
                                    this.popInterval(actualPosition, actualLine);
                                }
                            }
                            --nextPos;
                            continue block24;
                        }
                        ++actualLine;
                        continue block24;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        this.handleFinalCorrection();
        return this.rootInterval;
    }

    @Override
    public boolean isWithinString(StringBuilder document, int offset, Interval enclosingInterval) throws BadLocationException {
        Interval interval = enclosingInterval.getSmallestEnclosingInterval(offset);
        if (Interval.interval_type.MULTILINE_COMMENT.equals((Object)interval.getType()) || Interval.interval_type.SINGLELINE_COMMENT.equals((Object)interval.getType())) {
            return false;
        }
        int counter = 0;
        for (int start = interval.getStartOffset(); start < offset; ++start) {
            char curr = document.charAt(start);
            if (curr != '\"' && curr != '\'') continue;
            ++counter;
        }
        return counter % 2 != 0;
    }
}

