/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.EncodeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErrorBehaviorAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErrorBehaviorList;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappingTarget;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class EncodeTypeMappingTarget
extends TypeMappingTarget {
    private static final String FULLNAMEPART1 = ".<target_type>";
    private static final String FULLNAMEPART2 = ".<errorbehavior>";
    private final Type targetType;
    private final EncodeAttribute encodeAttribute;
    private final ErrorBehaviorAttribute errorBehaviorAttribute;

    public EncodeTypeMappingTarget(Type targetType, ExtensionAttribute encodeAttribute, ErrorBehaviorAttribute errorBehaviorAttribute) {
        this.targetType = targetType;
        this.encodeAttribute = encodeAttribute instanceof EncodeAttribute ? (EncodeAttribute)encodeAttribute : null;
        this.errorBehaviorAttribute = errorBehaviorAttribute;
        if (targetType != null) {
            targetType.setFullNameParent(this);
        }
    }

    @Override
    public TypeMappingTarget.TypeMapping_type getTypeMappingType() {
        return TypeMappingTarget.TypeMapping_type.ENCODE;
    }

    @Override
    public String getMappingName() {
        return "encode";
    }

    @Override
    public Type getTargetType() {
        return this.targetType;
    }

    public IType.MessageEncoding_type getCodingType() {
        if (this.encodeAttribute != null) {
            return this.encodeAttribute.getEncodingType();
        }
        return IType.MessageEncoding_type.UNDEFINED;
    }

    public boolean hasCodingOptions() {
        if (this.encodeAttribute != null) {
            return this.encodeAttribute.getOptions() != null;
        }
        return false;
    }

    public String getCodingOptions() {
        if (this.encodeAttribute != null) {
            return this.encodeAttribute.getOptions();
        }
        return "UNDEFINED";
    }

    public ErrorBehaviorList getErrrorBehaviorList() {
        return this.errorBehaviorAttribute.getErrrorBehaviorList();
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.targetType == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.errorBehaviorAttribute == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.targetType != null) {
            this.targetType.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Type sourceType, Port_Type portType, boolean legacy, boolean incoming) {
        Type streamType;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.targetType != null) {
            this.targetType.check(timestamp);
        }
        if (!sourceType.hasEncoding(timestamp, this.encodeAttribute.getEncodingType(), this.encodeAttribute.getOptions())) {
            sourceType.getLocation().reportSemanticError(MessageFormat.format("Source type `{0}'' does not support {1} encoding", sourceType.getTypename(), this.encodeAttribute.getEncodingType().getEncodingName()));
        }
        if ((streamType = Type.getStreamType(this.encodeAttribute.getEncodingType(), 1)) != null && !streamType.isIdentical(timestamp, this.targetType)) {
            this.targetType.getLocation().reportSemanticError(MessageFormat.format("Target type of {0} encoding should be `{1}'' instead of `{2}''", this.encodeAttribute.getEncodingType().getEncodingName(), streamType.getTypename(), this.targetType.getTypename()));
        }
        if (this.errorBehaviorAttribute != null) {
            this.errorBehaviorAttribute.getErrrorBehaviorList().check(timestamp);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.targetType != null) {
            this.targetType.updateSyntax(reparser, false);
            reparser.updateLocation(this.targetType.getLocation());
        }
        if (this.encodeAttribute != null) {
            this.encodeAttribute.updateSyntax(reparser, false);
            reparser.updateLocation(this.encodeAttribute.getLocation());
        }
        if (this.errorBehaviorAttribute != null) {
            this.errorBehaviorAttribute.updateSyntax(reparser, false);
            reparser.updateLocation(this.errorBehaviorAttribute.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.targetType != null) {
            this.targetType.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.targetType != null && !this.targetType.accept(v)) {
            return false;
        }
        if (this.encodeAttribute != null && !this.encodeAttribute.accept(v)) {
            return false;
        }
        return this.errorBehaviorAttribute == null || this.errorBehaviorAttribute.accept(v);
    }

    @Override
    public PortGenerator.MessageTypeMappingTarget fillTypeMappingTarget(JavaGenData aData, StringBuilder source, IType sourceType, AtomicBoolean hasSliding) {
        String targetTypeName = null;
        String displayName = null;
        String typeDescriptorName = null;
        hasSliding.set(false);
        if (this.targetType != null) {
            targetTypeName = this.targetType.getGenNameValue(aData, source);
            displayName = this.targetType.getTypename();
            typeDescriptorName = this.targetType.getGenNameTypeDescriptor(aData, source);
        }
        String encodingType = this.encodeAttribute.getEncodingType().getEncodingName();
        String encodingOptions = null;
        if (this.encodeAttribute.getOptions() != null) {
            encodingOptions = this.encodeAttribute.getOptions();
        }
        StringBuilder errorBehaviour = new StringBuilder();
        if (this.errorBehaviorAttribute != null) {
            this.errorBehaviorAttribute.getErrrorBehaviorList().generateCode(aData, errorBehaviour);
        } else {
            aData.addCommonLibraryImport("TTCN_EncDec");
            errorBehaviour.append("TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_DEFAULT);\n");
        }
        return new PortGenerator.MessageTypeMappingTarget(targetTypeName, displayName, typeDescriptorName, encodingType, encodingOptions, errorBehaviour.toString(), PortGenerator.MessageMappingType_type.ENCODE);
    }
}

