/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.readers.ValueReader;
import org.eclipse.titan.log.viewer.utils.ActionUtils;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.DetailsView;
import org.eclipse.titan.log.viewer.views.MSCView;
import org.eclipse.titan.log.viewer.views.details.DetailData;
import org.eclipse.titan.log.viewer.views.msc.model.EventObject;
import org.eclipse.titan.log.viewer.views.msc.model.ExecutionModel;
import org.eclipse.titan.log.viewer.views.msc.model.IEventObject;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.DelayedSelectable;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.DelayedSelector;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class OpenValueViewAction
extends SelectionProviderAction
implements DelayedSelectable {
    private static final String NAME = Messages.getString("OpenValueViewAction.0");
    private MSCView mscView;
    private Integer selectedLine;
    private final boolean forceEditorOpening;
    private ISelection delayedSelection = null;
    private DelayedSelector runnable = new DelayedSelector(this);

    public OpenValueViewAction(MSCView view, boolean forceEditorOpening) {
        super((ISelectionProvider)view.getMSCWidget(), NAME);
        this.mscView = view;
        this.forceEditorOpening = forceEditorOpening;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        super.dispose();
        this.runnable.setShouldRun(false);
        Object object = this.runnable.getLock();
        synchronized (object) {
            this.runnable.getLock().notifyAll();
        }
        this.runnable = null;
        this.mscView = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayedRun(ISelection selection) {
        this.delayedSelection = selection;
        if (!this.runnable.isAlive()) {
            this.runnable.setPriority(1);
            this.runnable.setDaemon(true);
            this.runnable.start();
        }
        Object object = this.runnable.getLock();
        synchronized (object) {
            this.runnable.getLock().notify();
        }
    }

    @Override
    public ISelection getDelayedSelection() {
        return this.delayedSelection;
    }

    @Override
    public void setDelayedSelection(ISelection delayedSelection) {
        this.delayedSelection = delayedSelection;
    }

    @Override
    public void run() {
        LogRecord logrecord;
        IProject project;
        if (this.selectedLine == null || this.mscView == null || this.selectedLine < 2 || this.selectedLine >= this.mscView.getModel().getNumberOfEvents() + 2) {
            return;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage == null) {
            return;
        }
        LogFileMetaData logFileMetaData = this.mscView.getLogFileMetaData();
        IFile logFile = this.getLogFileFromProject(logFileMetaData, project = this.getProjectByName(logFileMetaData));
        if (!logFile.exists()) {
            IViewReference[] viewReferences = activePage.getViewReferences();
            ActionUtils.closeAssociatedViews(activePage, viewReferences, (IResource)logFile);
            TitanLogExceptionHandler.handleException(new UserException(Messages.getString("OpenValueViewAction.1")));
            return;
        }
        if (LogFileCacheHandler.hasLogFileChanged(logFile)) {
            LogFileCacheHandler.handleLogFileChange(logFile);
            return;
        }
        DetailsView detailsview = (DetailsView)activePage.findView("org.eclipse.titan.log.viewer.views.DetailsView");
        if (detailsview == null && !this.forceEditorOpening) {
            return;
        }
        if (this.forceEditorOpening) {
            try {
                detailsview = (DetailsView)activePage.showView("org.eclipse.titan.log.viewer.views.DetailsView");
            }
            catch (PartInitException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenValueViewAction.4") + e.getMessage()));
                return;
            }
        }
        detailsview.setLogFileMetaData(this.mscView.getLogFileMetaData());
        ExecutionModel model = this.mscView.getModel();
        IEventObject ieventObject = model.getEvent(this.selectedLine - 2);
        if (!(ieventObject instanceof EventObject)) {
            return;
        }
        EventObject eventObject = (EventObject)ieventObject;
        String testCase = model.getTestCase().getTestCaseName();
        if (testCase == null || eventObject.getRecordNumber() == 0) {
            return;
        }
        try {
            logrecord = ValueReader.getInstance().readLogRecordFromLogFileCached(this.mscView.getLogFileMetaData().getFilePath(), eventObject);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenValueViewAction.3")));
            return;
        }
        String message = logrecord.getMessage();
        DetailData detailData = new DetailData(eventObject.getName(), eventObject.getPort(), message, testCase, eventObject.getEventType(), logrecord.getSourceInformation());
        detailsview.setData(detailData, false);
    }

    private IFile getLogFileFromProject(LogFileMetaData logFileMetaData, IProject project) {
        return project.getFile(logFileMetaData.getProjectRelativePath().substring(logFileMetaData.getProjectName().length() + 1));
    }

    private IProject getProjectByName(LogFileMetaData logFileMetaData) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        return root.getProject(logFileMetaData.getProjectName());
    }

    @Override
    public void selectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.selectedLine = (Integer)selection.getFirstElement();
    }
}

