/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.titan.common.logging.ErrorReporter;

public final class IOUtils {
    private IOUtils() {
    }

    public static void writeStringToFile(File file, String data) throws IOException {
        BufferedWriter outStream = null;
        try {
            outStream = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            outStream.write(data);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)outStream);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace("Error while closing a resource", e);
            }
        }
    }

    public static void closeQuietly(Closeable ... closeableArr) {
        for (Closeable closeable : closeableArr) {
            IOUtils.closeQuietly(closeable);
        }
    }

    public static String inputStreamToString(InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        StringBuilder content = new StringBuilder();
        char[] buffer = new char[1024];
        int n = reader.read(buffer);
        while (n != -1) {
            content.append(buffer, 0, n);
            n = reader.read(buffer);
        }
        return content.toString();
    }
}

