/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.PortReference;
import org.eclipse.titan.designer.AST.TTCN3.statements.Connect_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class ConnectionDetector
extends BaseModuleCodeSmellSpotter {
    private static final String ERROR_MESSAGE = "Neither port type `{0}'' nor port type `{1}'' can send messages";

    public ConnectionDetector() {
        super(CodeSmellType.CONNECTION_DETECTOR);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (node instanceof Connect_Statement) {
            Connect_Statement s = (Connect_Statement)node;
            IType portType1 = Port_Utility.checkConnectionEndpoint((CompilationTimeStamp)CompilationTimeStamp.getBaseTimestamp(), (Statement)s, (Value)s.getComponentReference1(), (PortReference)s.getPortReference1(), (boolean)false);
            IType portType2 = Port_Utility.checkConnectionEndpoint((CompilationTimeStamp)CompilationTimeStamp.getBaseTimestamp(), (Statement)s, (Value)s.getComponentReference2(), (PortReference)s.getPortReference2(), (boolean)false);
            if (portType1 == null || portType2 == null) {
                return;
            }
            PortTypeBody body1 = ((Port_Type)portType1).getPortBody();
            PortTypeBody body2 = ((Port_Type)portType2).getPortBody();
            if ((PortTypeBody.OperationModes.OP_Message.equals((Object)body1.getOperationMode()) || PortTypeBody.OperationModes.OP_Mixed.equals((Object)body1.getOperationMode())) && (PortTypeBody.OperationModes.OP_Message.equals((Object)body2.getOperationMode()) || PortTypeBody.OperationModes.OP_Mixed.equals((Object)body2.getOperationMode())) && body1.getOutMessage() == null && body2.getOutMessage() == null) {
                problems.report(s.getLocation(), MessageFormat.format(ERROR_MESSAGE, portType1.getTypename(), portType2.getTypename()));
            }
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(Connect_Statement.class);
        return ret;
    }
}

