/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.function;

import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titanium.refactoring.function.ExtractToFunctionRefactoring;

public class ExtractToFunctionWizardFuncNamePage
extends UserInputWizardPage {
    private static final String LABEL_NEWFUNCNAME = "New function name:";
    private static final String DEFAULT_FUNC_NAME = "newFunction";
    private Text newFuncName;

    public ExtractToFunctionWizardFuncNamePage(String name) {
        super(name);
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.initializeDialogUnits((Control)top);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(top, 0);
        label.setText(LABEL_NEWFUNCNAME);
        this.newFuncName = new Text(top, 2048);
        this.newFuncName.setLayoutData((Object)new GridData(768));
        this.newFuncName.setText(DEFAULT_FUNC_NAME);
        this.newFuncName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExtractToFunctionWizardFuncNamePage.this.checkNewNameValidity()) {
                    StringBuilder newFuncNameSB = ((ExtractToFunctionRefactoring)ExtractToFunctionWizardFuncNamePage.this.getRefactoring()).getNewFunctionName();
                    newFuncNameSB.setLength(0);
                    newFuncNameSB.append(ExtractToFunctionWizardFuncNamePage.this.newFuncName.getText());
                }
            }
        });
        this.newFuncName.setFocus();
        this.newFuncName.selectAll();
        this.checkNewNameValidity();
    }

    private boolean checkNewNameValidity() {
        String newName = this.newFuncName.getText();
        if (newName.length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return false;
        }
        Module mod = ((ExtractToFunctionRefactoring)this.getRefactoring()).getSelectedModule();
        switch (mod.getModuletype()) {
            case TTCN3_MODULE: {
                if (Identifier.isValidInTtcn((String)newName)) break;
                this.setErrorMessage("Not a valid TTCN-3 identifier!");
                this.setPageComplete(false);
                return false;
            }
            case ASN_MODULE: {
                if (Identifier.isValidInAsn((String)newName)) break;
                this.setErrorMessage("Not a valid ASN.1 identifier!");
                this.setPageComplete(false);
                return false;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR();
            }
        }
        Assignments assignments = mod.getAssignments();
        for (int i = 0; i < assignments.getNofAssignments(); ++i) {
            Assignment asg = assignments.getAssignmentByIndex(i);
            if (!asg.getIdentifier().getDisplayName().equals(newName)) continue;
            this.setErrorMessage("A function with the provided name already exists!");
            this.setPageComplete(false);
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }
}

