/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.finddefinition;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.finddefinition.DefinitionFinder;
import org.eclipse.titan.designer.finddefinition.StoredDefinitionFilter;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public final class DefinitionListSelectionDialog
extends ElementListSelectionDialog {
    private Label locationLabel;
    private final StoredDefinitionFilter filter;
    private final DefinitionFinder finder;

    public DefinitionListSelectionDialog(Shell parent, ILabelProvider renderer, IProject currentProject) {
        super(parent, renderer);
        this.filter = StoredDefinitionFilter.getInstance(currentProject);
        this.finder = new DefinitionFinder(this.filter);
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        this.createLocationLabel(control);
        this.createFilterSection(control);
        return control;
    }

    private Control createLocationLabel(Composite parent) {
        this.locationLabel = new Label(parent, 2048);
        this.locationLabel.setFont(parent.getFont());
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.locationLabel.setLayoutData((Object)data);
        return this.locationLabel;
    }

    private Control createFilterSection(Composite parent) {
        Composite main = new Composite(parent, 0);
        Group scopeGroup = new Group(main, 0);
        scopeGroup.setText("Scope");
        Button projectScope = new Button((Composite)scopeGroup, 16);
        projectScope.setText("In the same project");
        final Button workspaceScope = new Button((Composite)scopeGroup, 16);
        workspaceScope.setSelection(this.filter.getWorkspaceScope());
        workspaceScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefinitionListSelectionDialog.this.filter.setWorkspaceScope(workspaceScope.getSelection());
                DefinitionListSelectionDialog.this.applyDefinitionFilter();
            }
        });
        workspaceScope.setText("In the workspace");
        scopeGroup.setLayout((Layout)new GridLayout());
        Group typeGroup = new Group(main, 0);
        typeGroup.setText("Filter");
        final Button module = new Button((Composite)typeGroup, 32);
        module.setSelection(this.filter.getModules());
        module.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefinitionListSelectionDialog.this.filter.setModules(module.getSelection());
                DefinitionListSelectionDialog.this.applyDefinitionFilter();
            }
        });
        module.setText("modules");
        final Button function = new Button((Composite)typeGroup, 32);
        function.setSelection(this.filter.getFunctions());
        function.setText("functions, altsteps, testcases");
        function.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefinitionListSelectionDialog.this.filter.setFunctions(function.getSelection());
                DefinitionListSelectionDialog.this.applyDefinitionFilter();
            }
        });
        final Button type = new Button((Composite)typeGroup, 32);
        type.setSelection(this.filter.getTypes());
        type.setText("types");
        type.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefinitionListSelectionDialog.this.filter.setTypes(type.getSelection());
                DefinitionListSelectionDialog.this.applyDefinitionFilter();
            }
        });
        final Button globalVariables = new Button((Composite)typeGroup, 32);
        globalVariables.setSelection(this.filter.getGlobalVariables());
        globalVariables.setText("module parameters, global templates, global constants");
        globalVariables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefinitionListSelectionDialog.this.filter.setGlobalVariables(globalVariables.getSelection());
                DefinitionListSelectionDialog.this.applyDefinitionFilter();
            }
        });
        typeGroup.setLayout((Layout)new GridLayout(2, false));
        main.setLayout((Layout)new GridLayout(2, false));
        return parent;
    }

    private void applyDefinitionFilter() {
        Object[] arr = this.finder.findDefinitions().toArray();
        this.setSelection(null);
        this.setListElements(arr);
    }

    public void init() {
        Object[] arr = this.finder.findDefinitions().toArray();
        this.setElements(arr);
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        Object[] selectedElements = this.getSelectedElements();
        if (selectedElements.length > 0) {
            this.locationLabel.setText(((ILocateableNode)selectedElements[0]).getLocation().getFile().getFullPath().toOSString());
        }
    }
}

