/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.contentassist;

import java.util.regex.Matcher;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IParameterisedAssignment;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContextInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReferenceAnalyzer;

public class ParameterizedContext
extends ProposalContext {
    public ParameterizedContext(ProposalContextInfo proposalContextInfo) {
        super(proposalContextInfo);
        this.doFallback = false;
    }

    @Override
    public void getProposals(ProposalCollector propCollector) {
        Matcher matcher = this.proposalContextInfo.matcher;
        String id = matcher.group(1);
        String[] existingPars = matcher.group(2).split(",");
        int actualPar = existingPars.length;
        CompilationTimeStamp timestamp = this.proposalContextInfo.module.getLastCompilationTimeStamp();
        Reference reference = TTCN3ReferenceAnalyzer.parseForCompletion(this.proposalContextInfo.file, id);
        if (this.proposalContextInfo.scope == null) {
            return;
        }
        Assignment assignment = this.proposalContextInfo.scope.getAssBySRef(timestamp, reference);
        if (assignment == null) {
            return;
        }
        if (assignment instanceof IParameterisedAssignment) {
            IParameterisedAssignment pa = (IParameterisedAssignment)((Object)assignment);
            FormalParameterList fpl = pa.getFormalParameterList();
            if (fpl.getNofParameters() < actualPar) {
                return;
            }
            FormalParameter fp = fpl.getParameterByIndex(actualPar - 1);
            Type type = fp.getType(timestamp);
            if (type == null) {
                return;
            }
            IType.Type_type typeType = type.getTypetypeTtcn3();
            this.addItemsByType(type, typeType, propCollector, null, null);
        }
    }
}

